"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WatchStateMachine = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const constructs_1 = require("constructs");
const metrics_1 = require("./monitoring/aws/state-machine/metrics");
/**
 * @stability stable
 */
class WatchStateMachine extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.title = props.title;
        this.watchful = props.watchful;
        this.stateMachine = props.stateMachine;
        this.metricFailedThreshold = (_b = props.metricFailedThreshold) !== null && _b !== void 0 ? _b : 1;
        this.metrics = new metrics_1.StateMachineMetricFactory();
        this.createLinks();
        this.createExecutionMetrics();
    }
    createExecutionMetrics() {
        const execMetrics = this.metrics.metricExecutions(this.stateMachine.stateMachineArn);
        const { failed } = execMetrics;
        const failedWithPeriod = failed.with({
            statistic: 'sum',
            period: aws_cdk_lib_1.Duration.minutes(5),
        });
        const failureAlarm = failedWithPeriod.createAlarm(this, 'ExecutionFailures', {
            alarmDescription: `at ${this.metricFailedThreshold}`,
            threshold: this.metricFailedThreshold,
            comparisonOperator: aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            evaluationPeriods: 1,
        });
        this.watchful.addAlarm(failureAlarm);
        this.watchful.addWidgets(new aws_cloudwatch_1.GraphWidget({
            title: 'Overall Execution/min',
            width: 12,
            stacked: false,
            left: Object.values(execMetrics),
            leftAnnotations: [{ value: this.metricFailedThreshold, color: '#ff0000', label: 'Execution Failure Alarm' }],
        }));
    }
    createLinks() {
        this.watchful.addSection(this.title, {
            links: [{
                    title: 'Amazon State Machine',
                    url: `https://console.aws.amazon.com/states/home?region=${this.stateMachine.stack.region}#/statemachines/view/${this.stateMachine.stateMachineArn}`,
                }],
        });
    }
}
exports.WatchStateMachine = WatchStateMachine;
_a = JSII_RTTI_SYMBOL_1;
WatchStateMachine[_a] = { fqn: "cdk-watchful.WatchStateMachine", version: "0.6.29" };
//# sourceMappingURL=data:application/json;base64,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