import * as apigw from 'aws-cdk-lib/aws-apigateway';
import * as cloudwatch from 'aws-cdk-lib/aws-cloudwatch';
import * as dynamodb from 'aws-cdk-lib/aws-dynamodb';
import * as ecs from 'aws-cdk-lib/aws-ecs';
import { ApplicationTargetGroup } from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import * as rds from 'aws-cdk-lib/aws-rds';
import * as sns from 'aws-cdk-lib/aws-sns';
import * as sqs from 'aws-cdk-lib/aws-sqs';
import * as stepfunctions from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
import { IWatchful, SectionOptions } from './api';
import { WatchApiGatewayOptions, WatchApiGateway } from './api-gateway';
import { WatchfulAspectProps } from './aspect';
import { WatchDynamoTableOptions, WatchDynamoTable } from './dynamodb';
import { WatchEcsServiceOptions, WatchEcsService } from './ecs';
import { WatchLambdaFunctionOptions, WatchLambdaFunction } from './lambda';
import { WatchRdsAuroraOptions, WatchRdsAurora } from './rds-aurora';
import { WatchStateMachineOptions, WatchStateMachine } from './state-machine';
/**
 * @stability stable
 */
export interface WatchfulProps {
    /**
     * Email address to send alarms to.
     *
     * @default - alarms are not sent to an email recipient.
     * @stability stable
     */
    readonly alarmEmail?: string;
    /**
     * SQS queue to send alarms to.
     *
     * @default - alarms are not sent to an SQS queue.
     * @stability stable
     */
    readonly alarmSqs?: sqs.IQueue;
    /**
     * SNS topic to send alarms to.
     *
     * @default - alarms are not sent to an SNS Topic.
     * @stability stable
     */
    readonly alarmSns?: sns.ITopic;
    /**
     * The name of the CloudWatch dashboard generated by Watchful.
     *
     * @default - auto-generated
     * @stability stable
     */
    readonly dashboardName?: string;
    /**
     * ARNs of actions to perform when alarms go off.
     *
     * These actions are in
     * addition to email/sqs/sns.
     *
     * @default []
     *
     * You can use `alarmActions` instead as a strongly-typed alternative.
     * @stability stable
     */
    readonly alarmActionArns?: string[];
    /**
     * CloudWatch alarm actions to perform when alarms go off.
     *
     * These actions are
     * in addition to email/sqs/sns.
     *
     * @stability stable
     */
    readonly alarmActions?: cloudwatch.IAlarmAction[];
    /**
     * Whether to generate CloudWatch dashboards.
     *
     * @default true
     * @stability stable
     */
    readonly dashboard?: boolean;
}
/**
 * @stability stable
 */
export declare class Watchful extends Construct implements IWatchful {
    private readonly dash?;
    private readonly alarmTopic?;
    private readonly alarmActions;
    private createdAlarmCount;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: WatchfulProps);
    /**
     * @stability stable
     */
    addWidgets(...widgets: cloudwatch.IWidget[]): void;
    /**
     * @stability stable
     */
    addAlarm(alarm: cloudwatch.IAlarm): void;
    /**
     * @stability stable
     */
    addSection(title: string, options?: SectionOptions): void;
    /**
     * @stability stable
     */
    watchScope(scope: Construct, options?: WatchfulAspectProps): void;
    /**
     * @stability stable
     */
    watchDynamoTable(title: string, table: dynamodb.Table, options?: WatchDynamoTableOptions): WatchDynamoTable;
    /**
     * @stability stable
     */
    watchApiGateway(title: string, restApi: apigw.RestApi, options?: WatchApiGatewayOptions): WatchApiGateway;
    /**
     * @stability stable
     */
    watchLambdaFunction(title: string, fn: lambda.Function, options?: WatchLambdaFunctionOptions): WatchLambdaFunction;
    /**
     * @stability stable
     */
    watchStateMachine(title: string, stateMachine: stepfunctions.StateMachine, options?: WatchStateMachineOptions): WatchStateMachine;
    /**
     * @stability stable
     */
    watchRdsAuroraCluster(title: string, cluster: rds.DatabaseCluster, options?: WatchRdsAuroraOptions): WatchRdsAurora;
    /**
     * @stability stable
     */
    watchFargateEcs(title: string, fargateService: ecs.FargateService, targetGroup: ApplicationTargetGroup, options?: WatchEcsServiceOptions): WatchEcsService;
    /**
     * @stability stable
     */
    watchEc2Ecs(title: string, ec2Service: ecs.Ec2Service, targetGroup: ApplicationTargetGroup, options?: WatchEcsServiceOptions): WatchEcsService;
}
