"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Watchful = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cloudwatch = require("aws-cdk-lib/aws-cloudwatch");
const cloudwatch_actions = require("aws-cdk-lib/aws-cloudwatch-actions");
const sns = require("aws-cdk-lib/aws-sns");
const sns_subscriptions = require("aws-cdk-lib/aws-sns-subscriptions");
const constructs_1 = require("constructs");
const api_gateway_1 = require("./api-gateway");
const aspect_1 = require("./aspect");
const dynamodb_1 = require("./dynamodb");
const ecs_1 = require("./ecs");
const lambda_1 = require("./lambda");
const rds_aurora_1 = require("./rds-aurora");
const state_machine_1 = require("./state-machine");
const section_1 = require("./widget/section");
/**
 * @stability stable
 */
class Watchful extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b, _c;
        super(scope, id);
        this.createdAlarmCount = 0;
        this.alarmActions = [
            ...((_b = props.alarmActionArns) !== null && _b !== void 0 ? _b : []).map((alarmActionArn) => ({ bind: () => ({ alarmActionArn }) })),
            ...((_c = props.alarmActions) !== null && _c !== void 0 ? _c : []),
        ];
        if ((props.alarmEmail || props.alarmSqs) && !props.alarmSns) {
            this.alarmTopic = new sns.Topic(this, 'AlarmTopic', { displayName: 'Watchful Alarms' });
        }
        if (props.alarmSns) {
            this.alarmTopic = props.alarmSns;
        }
        if (props.alarmEmail && this.alarmTopic) {
            this.alarmTopic.addSubscription(new sns_subscriptions.EmailSubscription(props.alarmEmail));
        }
        if (props.alarmSqs && this.alarmTopic) {
            this.alarmTopic.addSubscription(new sns_subscriptions.SqsSubscription(
            // sqs.Queue.fromQueueArn(this, 'AlarmQueue', props.alarmSqs)
            props.alarmSqs));
        }
        if (props.dashboard === false && props.dashboardName) {
            throw new Error('Dashboard name is provided but dashboard creation is disabled');
        }
        if (props.dashboard !== false) {
            this.dash = new cloudwatch.Dashboard(this, 'Dashboard', { dashboardName: props.dashboardName });
            new aws_cdk_lib_1.CfnOutput(this, 'WatchfulDashboard', {
                value: linkForDashboard(this.dash),
            });
        }
    }
    /**
     * @stability stable
     */
    addWidgets(...widgets) {
        var _b;
        (_b = this.dash) === null || _b === void 0 ? void 0 : _b.addWidgets(...widgets);
    }
    /**
     * @stability stable
     */
    addAlarm(alarm) {
        const alarmWithAction = hasAlarmAction(alarm) ? alarm : new cloudwatch.CompositeAlarm(this, `Created Alarm ${this.createdAlarmCount++}`, {
            alarmRule: cloudwatch.AlarmRule.fromAlarm(alarm, cloudwatch.AlarmState.ALARM),
        });
        if (this.alarmTopic) {
            alarmWithAction.addAlarmAction(new cloudwatch_actions.SnsAction(this.alarmTopic));
        }
        alarmWithAction.addAlarmAction(...this.alarmActions);
    }
    /**
     * @stability stable
     */
    addSection(title, options = {}) {
        this.addWidgets(new section_1.SectionWidget({
            titleLevel: 1,
            titleMarkdown: title,
            quicklinks: options.links,
        }));
    }
    /**
     * @stability stable
     */
    watchScope(scope, options) {
        const aspect = new aspect_1.WatchfulAspect(this, options);
        aws_cdk_lib_1.Aspects.of(scope).add(aspect);
    }
    /**
     * @stability stable
     */
    watchDynamoTable(title, table, options = {}) {
        return new dynamodb_1.WatchDynamoTable(this, aws_cdk_lib_1.Names.uniqueId(table), {
            title,
            watchful: this,
            table,
            ...options,
        });
    }
    /**
     * @stability stable
     */
    watchApiGateway(title, restApi, options = {}) {
        return new api_gateway_1.WatchApiGateway(this, aws_cdk_lib_1.Names.uniqueId(restApi), {
            title, watchful: this, restApi, ...options,
        });
    }
    /**
     * @stability stable
     */
    watchLambdaFunction(title, fn, options = {}) {
        return new lambda_1.WatchLambdaFunction(this, aws_cdk_lib_1.Names.uniqueId(fn), {
            title, watchful: this, fn, ...options,
        });
    }
    /**
     * @stability stable
     */
    watchStateMachine(title, stateMachine, options = {}) {
        return new state_machine_1.WatchStateMachine(this, aws_cdk_lib_1.Names.uniqueId(stateMachine), {
            title, watchful: this, stateMachine, ...options,
        });
    }
    /**
     * @stability stable
     */
    watchRdsAuroraCluster(title, cluster, options = {}) {
        return new rds_aurora_1.WatchRdsAurora(this, aws_cdk_lib_1.Names.uniqueId(cluster), {
            title, watchful: this, cluster, ...options,
        });
    }
    /**
     * @stability stable
     */
    watchFargateEcs(title, fargateService, targetGroup, options = {}) {
        return new ecs_1.WatchEcsService(this, aws_cdk_lib_1.Names.uniqueId(fargateService), {
            title, watchful: this, fargateService, targetGroup, ...options,
        });
    }
    /**
     * @stability stable
     */
    watchEc2Ecs(title, ec2Service, targetGroup, options = {}) {
        return new ecs_1.WatchEcsService(this, aws_cdk_lib_1.Names.uniqueId(ec2Service), {
            title, watchful: this, ec2Service, targetGroup, ...options,
        });
    }
}
exports.Watchful = Watchful;
_a = JSII_RTTI_SYMBOL_1;
Watchful[_a] = { fqn: "cdk-watchful.Watchful", version: "0.6.29" };
function linkForDashboard(dashboard) {
    const cfnDashboard = dashboard.node.defaultChild;
    return `https://console.aws.amazon.com/cloudwatch/home?region=${dashboard.stack.region}#dashboards:name=${cfnDashboard.ref}`;
}
function hasAlarmAction(alarm) {
    return 'addAlarmAction' in alarm;
}
//# sourceMappingURL=data:application/json;base64,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