"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SectionWidget = void 0;
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
/**
 * Renders a section header in the following format:
 *
 * # Header
 * Description
 * [button:label1](url1) [button:label2](url2)
 */
class SectionWidget extends aws_cloudwatch_1.TextWidget {
    static toMarkdown(props) {
        var _a;
        const lines = [];
        // title
        const titlePrefix = '#'.repeat((_a = props.titleLevel) !== null && _a !== void 0 ? _a : 1);
        lines.push(`${titlePrefix} ${props.titleMarkdown}`);
        // description
        if (props.descriptionMarkdown) {
            lines.push(props.descriptionMarkdown);
        }
        // quick links
        if (props.quicklinks && props.quicklinks.length > 0) {
            lines.push(props.quicklinks.map(link => `[button:${link.title}](${link.url})`).join(' '));
        }
        return lines.join('\n\n');
    }
    constructor(props) {
        var _a, _b;
        super({ width: (_a = props.width) !== null && _a !== void 0 ? _a : 24, height: (_b = props.height) !== null && _b !== void 0 ? _b : 2, markdown: SectionWidget.toMarkdown(props) });
    }
}
exports.SectionWidget = SectionWidget;
//# sourceMappingURL=data:application/json;base64,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