from http import HTTPStatus
from typing import Any, Dict, Optional, Union

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.spring_error_payload import SpringErrorPayload
from ...types import Response


def _get_kwargs() -> Dict[str, Any]:

    pass

    return {
        "method": "post",
        "url": "api/jobs/scheduler/status/stop",
    }


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[SpringErrorPayload]:
    if response.status_code == HTTPStatus.INTERNAL_SERVER_ERROR:
        response_500 = SpringErrorPayload.from_dict(response.json())

        return response_500
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[SpringErrorPayload]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient,
) -> Response[SpringErrorPayload]:
    """stopCronScheduler

     Stops the job scheduler that runs monitoring jobs that are scheduled by assigning cron expressions.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[SpringErrorPayload]
    """

    kwargs = _get_kwargs()

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: AuthenticatedClient,
) -> Optional[SpringErrorPayload]:
    """stopCronScheduler

     Stops the job scheduler that runs monitoring jobs that are scheduled by assigning cron expressions.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        SpringErrorPayload
    """

    return sync_detailed(
        client=client,
    ).parsed


async def asyncio_detailed(
    *,
    client: AuthenticatedClient,
) -> Response[SpringErrorPayload]:
    """stopCronScheduler

     Stops the job scheduler that runs monitoring jobs that are scheduled by assigning cron expressions.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[SpringErrorPayload]
    """

    kwargs = _get_kwargs()

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: AuthenticatedClient,
) -> Optional[SpringErrorPayload]:
    """stopCronScheduler

     Stops the job scheduler that runs monitoring jobs that are scheduled by assigning cron expressions.

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        SpringErrorPayload
    """

    return (
        await asyncio_detailed(
            client=client,
        )
    ).parsed
