from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.check_container_model import CheckContainerModel
    from ..models.check_mining_proposal_model_column_checks import (
        CheckMiningProposalModelColumnChecks,
    )
    from ..models.check_search_filters import CheckSearchFilters


T = TypeVar("T", bound="CheckMiningProposalModel")


@_attrs_define
class CheckMiningProposalModel:
    """Model that has a proposed configuration of checks on a table and its columns generated by a data quality check
    mining service.

        Attributes:
            missing_current_statistics (Union[Unset, bool]): A boolean flag to inform the caller that the rule mining engine
                failed to propose relevant data quality rules because there are no current statistics. The user should schedule
                a 'collect statistics' job to analyze the table.
            missing_current_profiling_check_results (Union[Unset, bool]): A boolean flag to inform the caller that the rule
                mining engine failed to propose relevant data quality rules because there are no current results from profiling
                checks. The user should run profiling checks to analyze the table.
            table_checks (Union[Unset, CheckContainerModel]): Model that returns the form definition and the form data to
                edit all data quality checks divided by categories.
            column_checks (Union[Unset, CheckMiningProposalModelColumnChecks]): Dictionary of proposed data quality checks
                for each column.
            run_checks_job (Union[Unset, CheckSearchFilters]): Target data quality checks filter, identifies which checks on
                which tables and columns should be executed.
    """

    missing_current_statistics: Union[Unset, bool] = UNSET
    missing_current_profiling_check_results: Union[Unset, bool] = UNSET
    table_checks: Union[Unset, "CheckContainerModel"] = UNSET
    column_checks: Union[Unset, "CheckMiningProposalModelColumnChecks"] = UNSET
    run_checks_job: Union[Unset, "CheckSearchFilters"] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        missing_current_statistics = self.missing_current_statistics
        missing_current_profiling_check_results = (
            self.missing_current_profiling_check_results
        )
        table_checks: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.table_checks, Unset):
            table_checks = self.table_checks.to_dict()

        column_checks: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.column_checks, Unset):
            column_checks = self.column_checks.to_dict()

        run_checks_job: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.run_checks_job, Unset):
            run_checks_job = self.run_checks_job.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if missing_current_statistics is not UNSET:
            field_dict["missing_current_statistics"] = missing_current_statistics
        if missing_current_profiling_check_results is not UNSET:
            field_dict["missing_current_profiling_check_results"] = (
                missing_current_profiling_check_results
            )
        if table_checks is not UNSET:
            field_dict["table_checks"] = table_checks
        if column_checks is not UNSET:
            field_dict["column_checks"] = column_checks
        if run_checks_job is not UNSET:
            field_dict["run_checks_job"] = run_checks_job

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.check_container_model import CheckContainerModel
        from ..models.check_mining_proposal_model_column_checks import (
            CheckMiningProposalModelColumnChecks,
        )
        from ..models.check_search_filters import CheckSearchFilters

        d = src_dict.copy()
        missing_current_statistics = d.pop("missing_current_statistics", UNSET)

        missing_current_profiling_check_results = d.pop(
            "missing_current_profiling_check_results", UNSET
        )

        _table_checks = d.pop("table_checks", UNSET)
        table_checks: Union[Unset, CheckContainerModel]
        if isinstance(_table_checks, Unset):
            table_checks = UNSET
        else:
            table_checks = CheckContainerModel.from_dict(_table_checks)

        _column_checks = d.pop("column_checks", UNSET)
        column_checks: Union[Unset, CheckMiningProposalModelColumnChecks]
        if isinstance(_column_checks, Unset):
            column_checks = UNSET
        else:
            column_checks = CheckMiningProposalModelColumnChecks.from_dict(
                _column_checks
            )

        _run_checks_job = d.pop("run_checks_job", UNSET)
        run_checks_job: Union[Unset, CheckSearchFilters]
        if isinstance(_run_checks_job, Unset):
            run_checks_job = UNSET
        else:
            run_checks_job = CheckSearchFilters.from_dict(_run_checks_job)

        check_mining_proposal_model = cls(
            missing_current_statistics=missing_current_statistics,
            missing_current_profiling_check_results=missing_current_profiling_check_results,
            table_checks=table_checks,
            column_checks=column_checks,
            run_checks_job=run_checks_job,
        )

        check_mining_proposal_model.additional_properties = d
        return check_mining_proposal_model

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
