import datetime
from typing import Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..types import UNSET, Unset

T = TypeVar("T", bound="DeleteStoredDataQueueJobParameters")


@_attrs_define
class DeleteStoredDataQueueJobParameters:
    """
    Attributes:
        connection (Union[Unset, str]): The connection name.
        full_table_name (Union[Unset, str]): The schema and table name. It is provided as *<schema_name>.<table_name>*,
            for example *public.fact_sales*. This filter does not support patterns.
        date_start (Union[Unset, datetime.date]): The start date (inclusive) to delete the data, based on the
            *time_period* column in Parquet files.
        date_end (Union[Unset, datetime.date]): The end date (inclusive) to delete the data, based on the *time_period*
            column in Parquet files.
        delete_errors (Union[Unset, bool]): Delete the data from the [errors](../../reference/parquetfiles/errors.md)
            table. Because the default value is *false*, this parameter must be set to *true* to delete the errors.
        delete_statistics (Union[Unset, bool]): Delete the data from the
            [statistics](../../reference/parquetfiles/statistics.md) table. Because the default value is *false*, this
            parameter must be set to *true* to delete the statistics.
        delete_check_results (Union[Unset, bool]): Delete the data from the
            [check_results](../../reference/parquetfiles/check_results.md) table. Because the default value is *false*, this
            parameter must be set to *true* to delete the check results.
        delete_sensor_readouts (Union[Unset, bool]): Delete the data from the
            [sensor_readouts](../../reference/parquetfiles/sensor_readouts.md) table. Because the default value is *false*,
            this parameter must be set to *true* to delete the sensor readouts.
        delete_error_samples (Union[Unset, bool]): Delete the data from the
            [error_samples](../../reference/parquetfiles/error_samples.md) table. Because the default value is *false*, this
            parameter must be set to *true* to delete the error samples.
        delete_incidents (Union[Unset, bool]): Delete the data from the
            [incidents](../../reference/parquetfiles/incidents.md) table. Because the default value is *false*, this
            parameter must be set to *true* to delete the incidents.
        delete_checks_configuration (Union[Unset, bool]): Delete the data quality configured checks from the table. They
            are detached from the configuration.Because the default value is *false*, this parameter must be set to *true*
            to delete the checks configuration.
        column_names (Union[Unset, List[str]]): The list of column names to delete the data for column level results or
            errors only for selected columns.
        check_category (Union[Unset, str]): The check category name, for example *volume* or *anomaly*.
        table_comparison_name (Union[Unset, str]): The name of a table comparison configuration. Deletes only table
            comparison results (and errors) for a given comparison.
        check_name (Union[Unset, str]): The name of a data quality check. Uses the short check name, for example
            *daily_row_count*.
        check_type (Union[Unset, str]): The type of checks whose results and errors should be deleted. For example, use
            *monitoring* to delete only monitoring checks data.
        sensor_name (Union[Unset, str]): The full sensor name whose results, checks based on the sensor, statistics and
            errors generated by the sensor sound be deleted. Uses a full sensor name, for example: *table/volume/row_count*.
        data_group_tag (Union[Unset, str]): The names of data groups in any of the
            *grouping_level_1*...*grouping_level_9* columns in the Parquet tables. Enables deleting data tagged for one data
            source or a subset of results when the group level is captured from a column in a monitored table.
        quality_dimension (Union[Unset, str]): The data quality dimension name, for example *Timeliness* or
            *Completeness*.
        time_gradient (Union[Unset, str]): The time gradient (time scale) of the sensor and check results that are
            captured.
        collector_category (Union[Unset, str]): The statistics collector category when statistics should be deleted. A
            statistics category is a group of statistics, for example *sampling* for the column value samples.
        collector_name (Union[Unset, str]): The statistics collector name when only statistics are deleted for a
            selected collector, for example *sample_values*.
        collector_target (Union[Unset, str]): The type of the target object for which the basic statistics are deleted.
            Supported values are *table* and *column*.
        incident_status_name (Union[Unset, str]): The incidents status name when only incidents are deleted, for example
            *muted*.
    """

    connection: Union[Unset, str] = UNSET
    full_table_name: Union[Unset, str] = UNSET
    date_start: Union[Unset, datetime.date] = UNSET
    date_end: Union[Unset, datetime.date] = UNSET
    delete_errors: Union[Unset, bool] = UNSET
    delete_statistics: Union[Unset, bool] = UNSET
    delete_check_results: Union[Unset, bool] = UNSET
    delete_sensor_readouts: Union[Unset, bool] = UNSET
    delete_error_samples: Union[Unset, bool] = UNSET
    delete_incidents: Union[Unset, bool] = UNSET
    delete_checks_configuration: Union[Unset, bool] = UNSET
    column_names: Union[Unset, List[str]] = UNSET
    check_category: Union[Unset, str] = UNSET
    table_comparison_name: Union[Unset, str] = UNSET
    check_name: Union[Unset, str] = UNSET
    check_type: Union[Unset, str] = UNSET
    sensor_name: Union[Unset, str] = UNSET
    data_group_tag: Union[Unset, str] = UNSET
    quality_dimension: Union[Unset, str] = UNSET
    time_gradient: Union[Unset, str] = UNSET
    collector_category: Union[Unset, str] = UNSET
    collector_name: Union[Unset, str] = UNSET
    collector_target: Union[Unset, str] = UNSET
    incident_status_name: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        connection = self.connection
        full_table_name = self.full_table_name
        date_start: Union[Unset, str] = UNSET
        if not isinstance(self.date_start, Unset):
            date_start = self.date_start.isoformat()

        date_end: Union[Unset, str] = UNSET
        if not isinstance(self.date_end, Unset):
            date_end = self.date_end.isoformat()

        delete_errors = self.delete_errors
        delete_statistics = self.delete_statistics
        delete_check_results = self.delete_check_results
        delete_sensor_readouts = self.delete_sensor_readouts
        delete_error_samples = self.delete_error_samples
        delete_incidents = self.delete_incidents
        delete_checks_configuration = self.delete_checks_configuration
        column_names: Union[Unset, List[str]] = UNSET
        if not isinstance(self.column_names, Unset):
            column_names = self.column_names

        check_category = self.check_category
        table_comparison_name = self.table_comparison_name
        check_name = self.check_name
        check_type = self.check_type
        sensor_name = self.sensor_name
        data_group_tag = self.data_group_tag
        quality_dimension = self.quality_dimension
        time_gradient = self.time_gradient
        collector_category = self.collector_category
        collector_name = self.collector_name
        collector_target = self.collector_target
        incident_status_name = self.incident_status_name

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if connection is not UNSET:
            field_dict["connection"] = connection
        if full_table_name is not UNSET:
            field_dict["fullTableName"] = full_table_name
        if date_start is not UNSET:
            field_dict["dateStart"] = date_start
        if date_end is not UNSET:
            field_dict["dateEnd"] = date_end
        if delete_errors is not UNSET:
            field_dict["deleteErrors"] = delete_errors
        if delete_statistics is not UNSET:
            field_dict["deleteStatistics"] = delete_statistics
        if delete_check_results is not UNSET:
            field_dict["deleteCheckResults"] = delete_check_results
        if delete_sensor_readouts is not UNSET:
            field_dict["deleteSensorReadouts"] = delete_sensor_readouts
        if delete_error_samples is not UNSET:
            field_dict["deleteErrorSamples"] = delete_error_samples
        if delete_incidents is not UNSET:
            field_dict["deleteIncidents"] = delete_incidents
        if delete_checks_configuration is not UNSET:
            field_dict["deleteChecksConfiguration"] = delete_checks_configuration
        if column_names is not UNSET:
            field_dict["columnNames"] = column_names
        if check_category is not UNSET:
            field_dict["checkCategory"] = check_category
        if table_comparison_name is not UNSET:
            field_dict["tableComparisonName"] = table_comparison_name
        if check_name is not UNSET:
            field_dict["checkName"] = check_name
        if check_type is not UNSET:
            field_dict["checkType"] = check_type
        if sensor_name is not UNSET:
            field_dict["sensorName"] = sensor_name
        if data_group_tag is not UNSET:
            field_dict["dataGroupTag"] = data_group_tag
        if quality_dimension is not UNSET:
            field_dict["qualityDimension"] = quality_dimension
        if time_gradient is not UNSET:
            field_dict["timeGradient"] = time_gradient
        if collector_category is not UNSET:
            field_dict["collectorCategory"] = collector_category
        if collector_name is not UNSET:
            field_dict["collectorName"] = collector_name
        if collector_target is not UNSET:
            field_dict["collectorTarget"] = collector_target
        if incident_status_name is not UNSET:
            field_dict["incidentStatusName"] = incident_status_name

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        connection = d.pop("connection", UNSET)

        full_table_name = d.pop("fullTableName", UNSET)

        _date_start = d.pop("dateStart", UNSET)
        date_start: Union[Unset, datetime.date]
        if isinstance(_date_start, Unset):
            date_start = UNSET
        else:
            date_start = isoparse(_date_start).date()

        _date_end = d.pop("dateEnd", UNSET)
        date_end: Union[Unset, datetime.date]
        if isinstance(_date_end, Unset):
            date_end = UNSET
        else:
            date_end = isoparse(_date_end).date()

        delete_errors = d.pop("deleteErrors", UNSET)

        delete_statistics = d.pop("deleteStatistics", UNSET)

        delete_check_results = d.pop("deleteCheckResults", UNSET)

        delete_sensor_readouts = d.pop("deleteSensorReadouts", UNSET)

        delete_error_samples = d.pop("deleteErrorSamples", UNSET)

        delete_incidents = d.pop("deleteIncidents", UNSET)

        delete_checks_configuration = d.pop("deleteChecksConfiguration", UNSET)

        column_names = cast(List[str], d.pop("columnNames", UNSET))

        check_category = d.pop("checkCategory", UNSET)

        table_comparison_name = d.pop("tableComparisonName", UNSET)

        check_name = d.pop("checkName", UNSET)

        check_type = d.pop("checkType", UNSET)

        sensor_name = d.pop("sensorName", UNSET)

        data_group_tag = d.pop("dataGroupTag", UNSET)

        quality_dimension = d.pop("qualityDimension", UNSET)

        time_gradient = d.pop("timeGradient", UNSET)

        collector_category = d.pop("collectorCategory", UNSET)

        collector_name = d.pop("collectorName", UNSET)

        collector_target = d.pop("collectorTarget", UNSET)

        incident_status_name = d.pop("incidentStatusName", UNSET)

        delete_stored_data_queue_job_parameters = cls(
            connection=connection,
            full_table_name=full_table_name,
            date_start=date_start,
            date_end=date_end,
            delete_errors=delete_errors,
            delete_statistics=delete_statistics,
            delete_check_results=delete_check_results,
            delete_sensor_readouts=delete_sensor_readouts,
            delete_error_samples=delete_error_samples,
            delete_incidents=delete_incidents,
            delete_checks_configuration=delete_checks_configuration,
            column_names=column_names,
            check_category=check_category,
            table_comparison_name=table_comparison_name,
            check_name=check_name,
            check_type=check_type,
            sensor_name=sensor_name,
            data_group_tag=data_group_tag,
            quality_dimension=quality_dimension,
            time_gradient=time_gradient,
            collector_category=collector_category,
            collector_name=collector_name,
            collector_target=collector_target,
            incident_status_name=incident_status_name,
        )

        delete_stored_data_queue_job_parameters.additional_properties = d
        return delete_stored_data_queue_job_parameters

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
