from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.compression_type import CompressionType
from ..types import UNSET, Unset

T = TypeVar("T", bound="ParquetFileFormatSpec")


@_attrs_define
class ParquetFileFormatSpec:
    """
    Attributes:
        binary_as_string (Union[Unset, bool]): Parquet files generated by legacy writers do not correctly set the UTF8
            flag for strings, causing string columns to be loaded as BLOB instead. Set this to true to load binary columns
            as strings.
        filename (Union[Unset, bool]): Whether or not an extra filename column should be included in the result.
        file_row_number (Union[Unset, bool]): Whether or not to include the file_row_number column.
        hive_partitioning (Union[Unset, bool]): Whether or not to interpret the path as a hive partitioned path.
        union_by_name (Union[Unset, bool]): Whether the columns of multiple schemas should be unified by name, rather
            than by position.
        compression (Union[Unset, CompressionType]):
        no_compression_extension (Union[Unset, bool]): Whether the compression extension is present at the end of the
            file name.
        file_extension (Union[Unset, str]): Specifies a custom file name extension. The default is ".parquet".
    """

    binary_as_string: Union[Unset, bool] = UNSET
    filename: Union[Unset, bool] = UNSET
    file_row_number: Union[Unset, bool] = UNSET
    hive_partitioning: Union[Unset, bool] = UNSET
    union_by_name: Union[Unset, bool] = UNSET
    compression: Union[Unset, CompressionType] = UNSET
    no_compression_extension: Union[Unset, bool] = UNSET
    file_extension: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        binary_as_string = self.binary_as_string
        filename = self.filename
        file_row_number = self.file_row_number
        hive_partitioning = self.hive_partitioning
        union_by_name = self.union_by_name
        compression: Union[Unset, str] = UNSET
        if not isinstance(self.compression, Unset):
            compression = self.compression.value

        no_compression_extension = self.no_compression_extension
        file_extension = self.file_extension

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if binary_as_string is not UNSET:
            field_dict["binary_as_string"] = binary_as_string
        if filename is not UNSET:
            field_dict["filename"] = filename
        if file_row_number is not UNSET:
            field_dict["file_row_number"] = file_row_number
        if hive_partitioning is not UNSET:
            field_dict["hive_partitioning"] = hive_partitioning
        if union_by_name is not UNSET:
            field_dict["union_by_name"] = union_by_name
        if compression is not UNSET:
            field_dict["compression"] = compression
        if no_compression_extension is not UNSET:
            field_dict["no_compression_extension"] = no_compression_extension
        if file_extension is not UNSET:
            field_dict["file_extension"] = file_extension

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        binary_as_string = d.pop("binary_as_string", UNSET)

        filename = d.pop("filename", UNSET)

        file_row_number = d.pop("file_row_number", UNSET)

        hive_partitioning = d.pop("hive_partitioning", UNSET)

        union_by_name = d.pop("union_by_name", UNSET)

        _compression = d.pop("compression", UNSET)
        compression: Union[Unset, CompressionType]
        if isinstance(_compression, Unset):
            compression = UNSET
        else:
            compression = CompressionType(_compression)

        no_compression_extension = d.pop("no_compression_extension", UNSET)

        file_extension = d.pop("file_extension", UNSET)

        parquet_file_format_spec = cls(
            binary_as_string=binary_as_string,
            filename=filename,
            file_row_number=file_row_number,
            hive_partitioning=hive_partitioning,
            union_by_name=union_by_name,
            compression=compression,
            no_compression_extension=no_compression_extension,
            file_extension=file_extension,
        )

        parquet_file_format_spec.additional_properties = d
        return parquet_file_format_spec

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
