from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.table_current_data_quality_status_model import (
        TableCurrentDataQualityStatusModel,
    )
    from ..models.table_lineage_table_list_model_properties import (
        TableLineageTableListModelProperties,
    )


T = TypeVar("T", bound="TableLineageTableListModel")


@_attrs_define
class TableLineageTableListModel:
    """Data lineage model that describes one source or target table of the current table.

    Attributes:
        target_connection (Union[Unset, str]): The connection name where the target table is defined.
        target_schema (Union[Unset, str]): The schema name in the target connection where the target table is defined.
        target_table (Union[Unset, str]): The name of the target table inside the target schema.
        source_connection (Union[Unset, str]): The name of a source connection that is defined in DQOps and contains a
            source table from which the current table receives data.
        source_schema (Union[Unset, str]): The name of a source schema within the source connection that contains a
            source table from which the current table receives data.
        source_table (Union[Unset, str]): The name of a source schema within the source connection that contains a
            source table from which the current table receives data.
        data_lineage_source_tool (Union[Unset, str]): The name of a source tool from which this data lineage information
            was copied. This field should be filled when the data lineage was imported from another data catalog or a data
            lineage tracking platform.
        properties (Union[Unset, TableLineageTableListModelProperties]): A dictionary of mapping properties stored as a
            key/value dictionary. Data lineage synchronization tools that are importing data lineage mappings from external
            data lineage sources can use it to store mapping information.
        can_edit (Union[Unset, bool]): Boolean flag that decides if the current user can update or delete this object.
        table_data_quality_status (Union[Unset, TableCurrentDataQualityStatusModel]): The table's most recent data
            quality status. It is a summary of the results of the most recently executed data quality checks on the table.
            Verify the value of the highest_severity_level to see if there are any data quality issues on the table. The
            values of severity levels are: 0 - all data quality checks passed, 1 - a warning was detected, 2 - an error was
            detected, 3 - a fatal data quality issue was detected.
    """

    target_connection: Union[Unset, str] = UNSET
    target_schema: Union[Unset, str] = UNSET
    target_table: Union[Unset, str] = UNSET
    source_connection: Union[Unset, str] = UNSET
    source_schema: Union[Unset, str] = UNSET
    source_table: Union[Unset, str] = UNSET
    data_lineage_source_tool: Union[Unset, str] = UNSET
    properties: Union[Unset, "TableLineageTableListModelProperties"] = UNSET
    can_edit: Union[Unset, bool] = UNSET
    table_data_quality_status: Union[Unset, "TableCurrentDataQualityStatusModel"] = (
        UNSET
    )
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        target_connection = self.target_connection
        target_schema = self.target_schema
        target_table = self.target_table
        source_connection = self.source_connection
        source_schema = self.source_schema
        source_table = self.source_table
        data_lineage_source_tool = self.data_lineage_source_tool
        properties: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.properties, Unset):
            properties = self.properties.to_dict()

        can_edit = self.can_edit
        table_data_quality_status: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.table_data_quality_status, Unset):
            table_data_quality_status = self.table_data_quality_status.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if target_connection is not UNSET:
            field_dict["target_connection"] = target_connection
        if target_schema is not UNSET:
            field_dict["target_schema"] = target_schema
        if target_table is not UNSET:
            field_dict["target_table"] = target_table
        if source_connection is not UNSET:
            field_dict["source_connection"] = source_connection
        if source_schema is not UNSET:
            field_dict["source_schema"] = source_schema
        if source_table is not UNSET:
            field_dict["source_table"] = source_table
        if data_lineage_source_tool is not UNSET:
            field_dict["data_lineage_source_tool"] = data_lineage_source_tool
        if properties is not UNSET:
            field_dict["properties"] = properties
        if can_edit is not UNSET:
            field_dict["can_edit"] = can_edit
        if table_data_quality_status is not UNSET:
            field_dict["table_data_quality_status"] = table_data_quality_status

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.table_current_data_quality_status_model import (
            TableCurrentDataQualityStatusModel,
        )
        from ..models.table_lineage_table_list_model_properties import (
            TableLineageTableListModelProperties,
        )

        d = src_dict.copy()
        target_connection = d.pop("target_connection", UNSET)

        target_schema = d.pop("target_schema", UNSET)

        target_table = d.pop("target_table", UNSET)

        source_connection = d.pop("source_connection", UNSET)

        source_schema = d.pop("source_schema", UNSET)

        source_table = d.pop("source_table", UNSET)

        data_lineage_source_tool = d.pop("data_lineage_source_tool", UNSET)

        _properties = d.pop("properties", UNSET)
        properties: Union[Unset, TableLineageTableListModelProperties]
        if isinstance(_properties, Unset):
            properties = UNSET
        else:
            properties = TableLineageTableListModelProperties.from_dict(_properties)

        can_edit = d.pop("can_edit", UNSET)

        _table_data_quality_status = d.pop("table_data_quality_status", UNSET)
        table_data_quality_status: Union[Unset, TableCurrentDataQualityStatusModel]
        if isinstance(_table_data_quality_status, Unset):
            table_data_quality_status = UNSET
        else:
            table_data_quality_status = TableCurrentDataQualityStatusModel.from_dict(
                _table_data_quality_status
            )

        table_lineage_table_list_model = cls(
            target_connection=target_connection,
            target_schema=target_schema,
            target_table=target_table,
            source_connection=source_connection,
            source_schema=source_schema,
            source_table=source_table,
            data_lineage_source_tool=data_lineage_source_tool,
            properties=properties,
            can_edit=can_edit,
            table_data_quality_status=table_data_quality_status,
        )

        table_lineage_table_list_model.additional_properties = d
        return table_lineage_table_list_model

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
