# Configuration file for the Sphinx documentation builder.
#
# For the full list of built-in configuration values, see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Project information -----------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#project-information
import os
import sys


sys.path.insert(0, os.path.abspath('../..'))


project = 'redisimnest'
copyright = '2025, Ruhiddin'
author = 'Ruhiddin'
release = '0.10.0'

# -- General configuration ---------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#general-configuration

extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.napoleon",
    "sphinx.ext.viewcode",
    "sphinx_rtd_theme",
]


templates_path = ['_templates']
exclude_patterns = []


html_logo = "_static/logo.webp"

# -- Options for HTML output -------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-html-output

html_theme = 'sphinx_rtd_theme'
html_theme_options = {
    "logo_only": True,            # Show logo without project name
    "navigation_depth": 3,        # Levels of nested TOC visible
    "collapse_navigation": True,  # Collapse unused sections
    "sticky_navigation": True,    # Keep sidebar in view while scrolling
    "titles_only": False,         # Show only titles in sidebar (no module paths)
}

html_static_path = ['_static']

html_title = "redisimnest Documentation"
html_short_title = "redisimnest"
