import os
import pkg_resources
import sys
import textwrap

import click


@click.command()
@click.option('--dist', '--distribution', '-d', 'distribution', required=True)
@click.option('--out', '-o', type=click.File('w'), default=sys.stdout)
def cli(distribution, out):
    import pkg_resources

    version = pkg_resources.get_distribution(distribution).version

    out.write(textwrap.dedent('''\
        # This file is automatically generated by {me}
        __version__ = '{version}'
        __sha__ = '{sha}'
        __revision__ = '{revision}'
    '''.format(
        me=os.path.splitext(os.path.basename(sys.argv[0]))[0],
        version=version,
        sha='',
        revision='',
    )))
