# Contributing Guide
Welcome! We appreciate your interest in contributing.

## Issues

Report bugs using GitHub's Issue Tracker.
A useful bug report has detail, background, and sample code.
For example, try to include:

- A quick summary and/or background.
- Steps to reproduce:
  - Be specific!
  - Give sample code if you can.
- What you expected would happen.
- What actually happens.
- Any additional information that could help us.
  - Why you think this might be happening.
  - Things you tried that didn't work.
  - Etc.

## Pull Requests

We use the [Github Flow](https://docs.github.com/en/get-started/quickstart/github-flow), so all changes happen through pull requests.

For small bugs, feel free to open a pull request directly.
For larger bugs or enhancements, please open an issue first
Having an associated issue makes it easier to track changes and discuss proposals before you get started.

1. Fork the repo and create a new branch from `main`.
   - We suggest naming your branch `issue-##` if your pull request is addressing an open issue.
2. Make your changes.
   - If you've added code that should be tested, add tests.
   - If you've changed APIs, update the documentation.
3. Ensure the test suite passes and your code lints.
4. Open the pull request!

## Coding Style
Be consistent with the coding style of the repository you are contributing to.
Our projects generally have strict code formatters and linters which can fix basic style issues for you.

## License
Any contributions you make will be under the MIT Software License
Feel free to contact the maintainers if that's a concern.

## References
This document was adapted from an [adaptation](https://gist.github.com/briandk/3d2e8b3ec8daf5a27a62) of the open-source contribution guidelines for [Facebook's Draft](https://github.com/facebook/draft-js/blob/a9316a723f9e918afde44dea68b5f9f39b7d9b00/CONTRIBUTING.md).
