from .characters import RollHP, RollStats
from .options import Options
from .random import random_character
from .sheets import CharacterSheet


options = Options.parse()


roll_stats = RollStats(options.reroll_if_no_stat_is_14_plus)
roll_hp = RollHP(options.max_hp_at_first_level)


character = random_character(
    options.rng, roll_stats, roll_hp, options.starting_level
)
character_sheet = CharacterSheet(character)
print(character_sheet.render())
