from dataclasses import dataclass

from .language import common, dwarvish, elvish, goblinish, Language, orcish
from .language import sylvan
from .talents import ambitious, farsight, keen_senses, mighty, stealthy, stout
from .talents import Talent


@dataclass(frozen=True, slots=True)
class Ancestry:
    name: str
    languages: list[Language]
    talent: Talent

    def __repr__(self) -> str:
        return f'{self.__class__.__name__}({self.name!r})'

    def __str__(self) -> str:
        return self.name


dwarf = Ancestry('Dwarf', languages=[common, dwarvish], talent=stout)

elf = Ancestry('Elf', languages=[common, elvish, sylvan], talent=farsight)

goblin = Ancestry('Goblin', languages=[common, goblinish], talent=keen_senses)

halfling = Ancestry('Halfling', languages=[common], talent=stealthy)

half_orc = Ancestry('Half-Orc', languages=[common, orcish], talent=mighty)

human = Ancestry('Human', languages=[common], talent=ambitious)
