from dataclasses import dataclass


@dataclass(frozen=True, slots=True)
class Background:
    name: str
    description: str


# Background table, SD v4.8, p26

urchin = Background(
    'Urchin',
    'You grew up in the merciless streets of a large city',
)

wanted = Background(
    'Wanted', "There's a price on your head, but you have allies"
)

cult_initiate = Background(
    'Cult Initiate', 'You know blasphemous secrets and rituals'
)

thieves_guild = Background(
    "Thieves' Guild", 'You have connections, contacts and debts'
)

banished = Background(
    'Banished', 'Your people cast you out for supposed crimes'
)

orphaned = Background('Orphaned', 'An unusual guardian rescued and raised you')

wizards_apprentice = Background(
    "Wizard's Apprentice", 'You have a knack and eye for magic'
)

jeweler = Background(
    'Jeweler', 'You can easily appraise value and authenticity'
)

herbalist = Background('Herbalist', 'You know plants, medicines and poisons')

barbarian = Background(
    'Barbarian', 'You left the horde, but it never quite left you'
)

mercenary = Background(
    'Mercenary', 'You fought friend and foe alike for your coin'
)

sailor = Background(
    'Sailor', 'Pirate, privateer or merchant — the seas are yours'
)

acolyte = Background(
    'Acolyte', "You're well trained in religious rites and doctrines"
)

soldier = Background('Soldier', 'You served as a fighter in an organized army')

ranger = Background('Ranger', 'The woods and wilds are your true home')

scout = Background('Scout', 'You survived on stealth, observation and speed')

minstrel = Background(
    'Minstrel', "You've traveled far with your charm and talent"
)

scholar = Background('Scholar', 'You know much about ancient history and lore')

noble = Background('Noble', 'A famous name has opened many doors for you')

chirurgeon = Background('Chirurgeon', 'You know anatomy, surgery and first aid')
