from dataclasses import dataclass

from .alignment import Alignment


@dataclass(frozen=True, slots=True)
class Deity:
    name: str
    alignment: Alignment
    description: str

    def __str__(self) -> str:
        return f'{self.name} ({self.alignment.title()})'


# Deities, SD v4.8, pp28-29

terragnis = Deity(
    'Saint Terragnis',
    Alignment.LAWFUL,
    'The embodiment of righteousness and justice',
)

gede = Deity(
    'Gede',
    Alignment.NEUTRAL,
    'The god of feasts, mirth and the wilds',
)

madeera = Deity(
    'Madeera the Covenant',
    Alignment.LAWFUL,
    'The first manifestation of Law',
)

ord = Deity(
    'Ord',
    Alignment.NEUTRAL,
    'The god of magic, knowledge, secrets and equilibrium',
)

memnon = Deity(
    'Memnon',
    Alignment.CHAOTIC,
    'The first manifestation of Chaos',
)

shune = Deity(
    'Shune the Vile',
    Alignment.CHAOTIC,
    'Whispers arcane secrets to sorcerers and witches',
)

ramlaat = Deity(
    'Ramlaat',
    Alignment.CHAOTIC,
    'The Pillager, the Barbaric, the Horde',
)
