from dataclasses import dataclass
from enum import auto, StrEnum


class LanguageFrequency(StrEnum):
    COMMON = auto()
    RARE = auto()


@dataclass(frozen=True, slots=True)
class Language:
    name: str
    who_speaks_it: str
    frequency: LanguageFrequency = LanguageFrequency.COMMON

    def __repr__(self) -> str:
        return f'{self.__class__.__name__}({self.name!r})'

    def __str__(self) -> str:
        return self.name


# Common Languages table, SD v4.8, p32

common = Language('Common', 'Most humanoids')

dwarvish = Language('Dwarvish', 'dwarves')

elvish = Language('Elvish', 'elves')

giant = Language('Giant', 'giants, ogres, trolls')

goblinish = Language('Goblin', 'bugbears, goblins, hobgoblins')

merran = Language('Merran', 'merfolk, sahuagin, sirens')

orcish = Language('Orcish', 'orcs')

reptilian = Language('Reptilian', 'lizardfolk, viperians')

sylvan = Language('Sylvan', 'centaurs, dryads, faeries')

thanian = Language('Thanian', 'minotaurs, beastmen, manticores')


# Rare Languages table, SD v4.8, p32

celestial = Language('Celestial', 'angels', LanguageFrequency.RARE)

diabolic = Language('Diabolic', 'demons, devils', LanguageFrequency.RARE)

draconic = Language('Draconic', 'dragons', LanguageFrequency.RARE)

primordial = Language(
    'Primordial', 'elder things, elementals', LanguageFrequency.RARE
)
