from dataclasses import dataclass

from ndice import d4, d6, d8, Dice

from ..gear import all_armor, all_weapons, Armor, club, crossbow, dagger
from ..gear import leather_armor, longsword, mace, mithral_chainmail, shortbow
from ..gear import shortsword, staff, warhammer, Weapon
from .talents import apply_disguise, backstab, climb, find_and_disable_traps
from .talents import grit, hauler, pick_pockets_and_open_locks, sneak_and_hide
from .talents import Talent, weapon_mastery


@dataclass(frozen=True, slots=True)
class Profession:
    name: str
    weapons: list[Weapon]
    armor: list[Armor]
    hp_per_level: Dice
    talents: list[Talent]

    def __str__(self) -> str:
        return self.name


# Fighter Class, SD v4.8, p18
fighter = Profession(
    'Fighter',
    all_weapons,
    all_armor,
    hp_per_level=d8,
    talents=[hauler, weapon_mastery, grit],
)

# Priest Class, SD v4.8, p20
priest = Profession(
    'Priest',
    [club, crossbow, dagger, mace, longsword, staff, warhammer],
    all_armor,
    hp_per_level=d6,
    talents=[],
)

# Thief Class, SD v4.8, p22
thief = Profession(
    'Thief',
    [club, crossbow, dagger, shortbow, shortsword],
    [leather_armor, mithral_chainmail],
    hp_per_level=d4,
    talents=[
        backstab,
        climb,
        sneak_and_hide,
        apply_disguise,
        find_and_disable_traps,
        pick_pockets_and_open_locks,
    ],
)

# Wizard Class, SD v4.8, p24
no_armor: list[Armor] = []
wizard = Profession(
    'Wizard',
    [dagger, staff],
    no_armor,
    hp_per_level=d4,
    talents=[],
)
