from dataclasses import dataclass

from ndice import max_roll, plus, RNG, roll

from sd.mechanics import mod_value, roll_with_advantage

from .profession import Profession
from .stats import Con
from .talents import stout, Talent


# Starting Level, SD v4.8, p14
# Ancestry: Dwarf, SD v4.8, p16
# House Rule: Receive max HP at first level
@dataclass(frozen=True, slots=True)
class RollHP:
    max_hp_at_first_level: bool

    def __call__(
        self,
        rng: RNG,
        level: int,
        profession: Profession | None,
        con: Con,
        talents: list[Talent],
    ) -> int:
        if stout in talents:
            stout_bonus = plus(0) if level > 1 else plus(2)
            roll_hp = roll_with_advantage
        else:
            stout_bonus = plus(0)
            roll_hp = roll

        if 0 == level:
            hp = mod_value(con.mod, stout_bonus)
        elif 1 == level and self.max_hp_at_first_level:
            assert profession
            hp = max_roll(profession.hp_per_level, con.mod, stout_bonus)
        else:
            assert profession
            hp = roll_hp(rng, profession.hp_per_level, con.mod, stout_bonus)
        return max(1, hp)
