from dataclasses import dataclass


@dataclass(frozen=True, slots=True)
class Spell:
    level: int
    name: str

    def __str__(self) -> str:
        return self.name


# Priest Spell List, SD v4.8, p51

cure_wounds = Spell(1, 'Cure Wounds')
holy_weapon = Spell(1, 'Holy Weapon')
light = Spell(1, 'Light')
protection_from_evil = Spell(1, 'Protection From Evil')
shield_of_faith = Spell(1, 'Shield of Faith')
turn_undead = Spell(1, 'Turn Undead')

augury = Spell(2, 'Augury')
bless = Spell(2, 'Bless')
blind_deafen = Spell(2, 'Blind/Deafen')
cleansing_weapon = Spell(2, 'Cleansing Weapon')
smite = Spell(2, 'Smite')
zone_of_truth = Spell(2, 'Zone of Truth')

command = Spell(3, 'Command')
lay_to_rest = Spell(3, 'Lay To Rest')
mass_cure = Spell(3, 'Mass Cure')
rebuke_unholy = Spell(3, 'Rebuke Unholy')
restoration = Spell(3, 'Restoration')
speak_with_dead = Spell(3, 'Speak With Dead')

commune = Spell(4, 'Commune')
control_water = Spell(4, 'Control Water')
flame_strike = Spell(4, 'Flame Strike')
pillar_of_salt = Spell(4, 'Pillar of Salt')
regenerate = Spell(4, 'Regenerate')
wrath = Spell(4, 'Wrath')

divine_vengeance = Spell(5, 'Divine Vengeance')
dominion = Spell(5, 'Dominion')
heal = Spell(5, 'Heal')
judgment = Spell(5, 'Judgment')
plane_shift = Spell(5, 'Plane Shift')
prophecy = Spell(5, 'Prophecy')


# Wizard Spell List, SD v4.8, pp52-53

alarm = Spell(1, 'Alarm')
burning_hands = Spell(1, 'Burning Hands')
charm_person = Spell(1, 'Charm Person')
detect_magic = Spell(1, 'Detect Magic')
feather_fall = Spell(1, 'Feather Fall')
floating_disk = Spell(1, 'Floating Disk')
hold_portal = Spell(1, 'Hold Portal')
# light, same as priest spell
mage_armor = Spell(1, 'Mage Armor')
magic_missile = Spell(1, 'Magic Missile')
# protection_from_evil, same as priest spell
sleep = Spell(1, 'Sleep')

acid_arrow = Spell(2, 'Acid Arrow')
alter_self = Spell(2, 'Alter Self')
detect_thoughts = Spell(2, 'Detect Thoughts')
fixed_object = Spell(2, 'Fixed Object')
hold_person = Spell(2, 'Hold Person')
invisibility = Spell(2, 'Invisibility')
knock = Spell(2, 'Knock')
levitate = Spell(2, 'Levitate')
mirror_image = Spell(2, 'Mirror Image')
misty_step = Spell(2, 'Misty Step')
silence = Spell(2, 'Silence')
web = Spell(2, 'Web')

animate_dead = Spell(3, 'Animate Dead')
dispel_magic = Spell(3, 'Dispel Magic')
fabricate = Spell(3, 'Fabricate')
fireball = Spell(3, 'Fireball')
fly = Spell(3, 'Fly')
gaseous_form = Spell(3, 'Gaseous Form')
illusion = Spell(3, 'Illusion')
lightning_bolt = Spell(3, 'Lightning Bolt')
magic_circle = Spell(3, 'Magic Circle')
protection_from_energy = Spell(3, 'Protection From Energy')
sending = Spell(3, 'Sending')
# speak_with_dead, same as priest spell

arcane_eye = Spell(4, 'Arcane Eye')
cloudkill = Spell(4, 'Cloudkill')
confusion = Spell(4, 'Confusion')
# control_water, same as priest spell
dimension_door = Spell(4, 'Dimension Door')
divination = Spell(4, 'Divination')
passwall = Spell(4, 'Passwall')
polymorph = Spell(4, 'Polymorph')
resilient_sphere = Spell(4, 'Resilient Sphere')
stoneskin = Spell(4, 'Stoneskin')
telekinesis = Spell(4, 'Telekinesis')
wall_of_force = Spell(4, 'Wall of Force')

antimagic_shell = Spell(5, 'Antimagic Shell')
create_undead = Spell(5, 'Create Undead')
disintegrate = Spell(5, 'Disintegrate')
hold_monster = Spell(5, 'Hold Monster')
# plane_shift, same as priest spell
power_word_kill = Spell(5, 'Power Word Kill')
prismatic_orb = Spell(5, 'Prismatic Orb')
scrying = Spell(5, 'Scrying')
shapechange = Spell(5, 'Shapechange')
summon_extraplanar = Spell(5, 'Summon Extraplanar')
teleport = Spell(5, 'Teleport')
wish = Spell(5, 'Wish')
