from dataclasses import dataclass

from ndice import RNG

from .stats import Stats


@dataclass(frozen=True, slots=True)
class RollStats:
    reroll_if_no_stat_is_14_plus: bool

    def __call__(self, rng: RNG) -> Stats:
        if self.reroll_if_no_stat_is_14_plus:
            return Stats.roll_with_one_min_stat(rng, 14)
        else:
            return Stats.roll_3d6_down_the_line(rng)
