from abc import ABC, abstractmethod
from typing import Any

from ndice import Dice

from sd.mechanics import clamp, make_mod


class Stat(ABC):
    def __init__(self, value: int):
        assert value >= 0
        self.value = value

    @property
    @abstractmethod
    def abbreviation(self) -> str: ...

    @property
    def mod(self) -> Dice:
        """Stats table, SD v4.8, p15"""
        mod_value = (self.value - 10) // 2
        return make_mod(clamp(-4, mod_value, 4))

    @property
    @abstractmethod
    def name(self) -> str: ...

    def __eq__(self, other: Any) -> bool:
        if isinstance(other, self.__class__):
            return self.value == other.value
        elif isinstance(other, int):
            return self.value == other
        else:
            return NotImplemented

    def __repr__(self) -> str:
        return f'{self.__class__.__name__}({self.value})'
