from dataclasses import dataclass


@dataclass(frozen=True, slots=True)
class Talent:
    name: str
    description: str

    def __repr__(self) -> str:
        return f'<{self.__class__.__name__}: {self.name}>'

    def __str__(self) -> str:
        return f'{self.name}: {self.description}'
