from dataclasses import dataclass

from .talent import Talent


@dataclass(frozen=True, slots=True)
class TalentChoice(Talent):
    choices: list[Talent]

    def __repr__(self) -> str:
        return f'<{self.__class__.__name__}: {self.name}>'

    def __str__(self) -> str:
        return f'{self.name}: {self.description}'
