from ...gear import bastard_sword, club, crossbow, dagger, greataxe
from ...gear import greatsword, javelin, longbow, longsword, mace, shortbow
from ...gear import shortsword, spear, staff, warhammer
from .talent import Talent
from .talent_choice import TalentChoice
from .weapon_mastery import WeaponMastery


# Dwarf, SD v4.8, p16
stout = Talent(
    name='Stout',
    description='start with +2 HP; roll HP with advantage',
)

# Elf, SD v4.8, p16

farsight_ranged = Talent(
    name='Farsight',
    description='+1 to attack rolls with ranged weapons',
)

farsight_spell = Talent(
    name='Farsight',
    description='+1 to spellcasting checks',
)

farsight = TalentChoice(
    name='Farsight',
    description=(
        '+1 to attack rolls with ranged weapons or +1 to spellcasting checks'
    ),
    choices=[farsight_ranged, farsight_spell],
)

# Goblin, SD v4.8, p16
keen_senses = Talent(name='Keen Senses', description="you can't be surprised")

# Half-ord, SD v4.8, p16
mighty = Talent(
    name='Mighty',
    description='+1 to attack and damage rolls with melee weapons',
)

# Halfling, SD v4.8, p17
stealthy = Talent(
    name='Stealthy',
    description='1/day become invisible for 3 rounds',
)

# Human, SD v4.8, p17
ambitious = Talent(
    name='Ambitious',
    description='one more talent roll at 1st level',
)

# Fighter Class, SD v4.8, p18

hauler = Talent(
    name='Hauler',
    description='add CON mod (if positive) to gear slots',
)

bastard_sword_mastery = WeaponMastery(
    name='Bastard Sword Mastery',
    description=(
        '+1 + level/2 (rnd down) to attack and damage rolls with bastard swords'
    ),
    weapon=bastard_sword,
)

club_mastery = WeaponMastery(
    name='Club Mastery',
    description='+1 + level/2 (rnd down) to attack and damage rolls with clubs',
    weapon=club,
)

crossbow_mastery = WeaponMastery(
    name='Crossbow Mastery',
    description=(
        '+1 + level/2 (rnd down) to attack and damage rolls with crossbows'
    ),
    weapon=crossbow,
)

dagger_mastery = WeaponMastery(
    name='Dagger Mastery',
    description=(
        '+1 + level/2 (rnd down) to attack and damage rolls with daggers'
    ),
    weapon=dagger,
)

greataxe_mastery = WeaponMastery(
    name='Greataxe Mastery',
    description=(
        '+1 + level/2 (rnd down) to attack and damage rolls with greataxes'
    ),
    weapon=greataxe,
)

greatsword_mastery = WeaponMastery(
    name='Greatsword Mastery',
    description=(
        '+1 + level/2 (rnd down) to attack and damage rolls with greatswords'
    ),
    weapon=greatsword,
)

javelin_mastery = WeaponMastery(
    name='Javelin Mastery',
    description=(
        '+1 + level/2 (rnd down) to attack and damage rolls with javelins'
    ),
    weapon=javelin,
)

longbow_mastery = WeaponMastery(
    name='Longbow Mastery',
    description=(
        '+1 + level/2 (rnd down) to attack and damage rolls with longbows'
    ),
    weapon=longbow,
)

longsword_mastery = WeaponMastery(
    name='Longsword Mastery',
    description=(
        '+1 + level/2 (rnd down) to attack and damage rolls with longswords'
    ),
    weapon=longsword,
)

mace_mastery = WeaponMastery(
    name='Mace Mastery',
    description='+1 + level/2 (rnd down) to attack and damage rolls with maces',
    weapon=mace,
)

shortbow_mastery = WeaponMastery(
    name='Shortbow Mastery',
    description=(
        '+1 + level/2 (rnd down) to attack and damage rolls with shortbows'
    ),
    weapon=shortbow,
)

shortsword_mastery = WeaponMastery(
    name='Shortsword Mastery',
    description=(
        '+1 + level/2 (rnd down) to attack and damage rolls with shortswords'
    ),
    weapon=shortsword,
)

spear_mastery = WeaponMastery(
    name='Spear Mastery',
    description=(
        '+1 + level/2 (rnd down) to attack and damage rolls with spears'
    ),
    weapon=spear,
)

staff_mastery = WeaponMastery(
    name='Staff Mastery',
    description=(
        '+1 + level/2 (rnd down) to attack and damage rolls with staves'
    ),
    weapon=staff,
)

warhammer_mastery = WeaponMastery(
    name='Warhammer Mastery',
    description=(
        '+1 + level/2 (rnd down) to attack and damage rolls with warhammers'
    ),
    weapon=warhammer,
)

weapon_mastery = TalentChoice(
    name='Weapon Mastery',
    description=(
        '+1 + level/2 (round down) to attack and damage rolls'
        ' with 1 weapon type'
    ),
    choices=[
        bastard_sword_mastery,
        club_mastery,
        crossbow_mastery,
        dagger_mastery,
        greataxe_mastery,
        greatsword_mastery,
        javelin_mastery,
        longbow_mastery,
        longsword_mastery,
        mace_mastery,
        shortbow_mastery,
        shortsword_mastery,
        spear_mastery,
        staff_mastery,
        warhammer_mastery,
    ],
)

grit_str = Talent(
    name='Grit',
    description='advantage on STR checks to overcome an opposing force',
)

grit_dex = Talent(
    name='Grit',
    description='advantage on DEX checks to overcome an opposing force',
)

grit = TalentChoice(
    name='Grit',
    description='advantage on STR or DEX checks to overcome an opposing force',
    choices=[grit_str, grit_dex],
)

# Thief Class, SD v4.8, p22

backstab = Talent(
    name='Backstab',
    description=(
        '+1 + level/2 (rnd down) dice of damage if you hit an unaware foe'
    ),
)

climb = Talent(
    name='Climb',
    description='advantage on climb checks',
)

sneak_and_hide = Talent(
    name='Sneak and Hide',
    description='advantage on sneak and hide checks',
)

apply_disguise = Talent(
    name='Apply Disguise',
    description='advantage on apply disguise checks',
)

find_and_disable_traps = Talent(
    name='Find and Disable Traps',
    description='advantage on find and disable traps checks',
)

pick_pockets_and_open_locks = Talent(
    name='Pick Pockets and Open Locks',
    description='advantage on pick pocket and open lock checks',
)
