from __future__ import annotations

from dataclasses import dataclass
from fractions import Fraction
from typing import Any


@dataclass(frozen=True, order=True, slots=True)
class Slots:
    value: Fraction

    def __init__(self, value: Fraction | int):
        if isinstance(value, int):
            value = Fraction(value)
        object.__setattr__(self, 'value', value)

    def __add__(self, other: Any) -> Slots:
        if isinstance(other, Slots):
            return Slots(self.value + other.value)
        return NotImplemented

    def __rmul__(self, other: Any) -> Slots:
        factor = other_factor(other)
        if factor is None:
            return NotImplemented
        else:
            return Slots(self.value * factor)

    def __round__(self, n: int | None = None) -> Slots:
        return Slots(round(self.value, n))

    def __str__(self) -> str:
        return str(self.value)

    def __sub__(self, other: Any) -> Slots:
        if isinstance(other, Slots):
            return Slots(self.value - other.value)
        return NotImplemented

    def __truediv__(self, other: Any) -> Slots:
        factor = other_factor(other)
        if factor is None:
            return NotImplemented
        else:
            return Slots(self.value / factor)


slots = Slots(1)


def other_factor(other: Any) -> Fraction | None:
    if isinstance(other, Fraction):
        return other
    elif isinstance(other, int):
        return Fraction(other)
    else:
        return None
