from dataclasses import dataclass


@dataclass(frozen=True, order=True, slots=True)
class Word:
    singular: str
    plural: str | None = None

    def __post_init__(self) -> None:
        assert self.singular

    @property
    def is_regular(self) -> bool:
        return not self.plural

    def __repr__(self) -> str:
        if self.plural:
            return f'Word({self.singular!r}, {self.plural!r})'
        else:
            return f'Word({self.singular!r})'

    def __str__(self) -> str:
        return self.singular

    def inflect(self, number: int) -> str:
        if 1 == number:
            return self.singular
        else:
            return self.plural or self.singular + 's'
