from ndice import Dice, Op

from .make_mod import make_mod
from .mod_value import mod_value


def simplify_mods(*expression: Dice) -> list[Dice]:
    new_expression = []
    group: list[Dice] = []

    def shift() -> None:
        nonlocal new_expression, group
        new_expression += coalesce(group)
        group = []

    for dice in expression:
        if dice.is_mod:
            if Op.TIMES == dice.op:
                shift()
                new_expression.append(dice)
            else:
                group.append(dice)
        else:
            shift()
            new_expression.append(dice)
    shift()
    return new_expression


def coalesce(group: list[Dice]) -> list[Dice]:
    value = mod_value(*group)
    return [make_mod(value)] if value else []
