from ndice import RNG

from ..characters import Alignment, Deity, priest, Profession
from .alignment_table import alignment_table
from .deity_table import deity_table


# Priest Class, SD v4.8, p20
def roll_alignment_and_deity(
    rng: RNG, profession: Profession
) -> tuple[Alignment, Deity]:
    if priest == profession:
        deity = deity_table.roll(rng)
        return deity.alignment, deity
    else:
        return alignment_table.roll(rng), deity_table.roll(rng)
