from ndice import RNG

from ..characters import Ancestry, diabolic, human, Language, priest
from ..characters import Profession, wizard
from .common_language_table import common_language_table
from .rare_language_table import rare_language_table


def roll_ancestry_languages(rng: RNG, ancestry: Ancestry) -> list[Language]:
    if human == ancestry:
        additional = [common_language_table.roll(rng)]
    else:
        additional = []
    return ancestry.languages + additional


def roll_profession_languages(
    rng: RNG, profession: Profession, known_languages: list[Language]
) -> list[Language]:
    if priest == profession:
        return rare_language_table.pick(rng, 1, skip=[diabolic])
    elif wizard == profession:
        common = common_language_table.pick(rng, 2, skip=known_languages)
        rare = rare_language_table.pick(rng, 2)
        return common + rare
    else:
        return []
