from ndice import RNG

from ..characters import Ancestry, dwarf, elf, goblin, half_orc, halfling
from ..characters import human
from ..tables import Table


def roll_name(rng: RNG, ancestry: Ancestry) -> str:
    if dwarf == ancestry:
        table = dwarf_names_table
    elif elf == ancestry:
        table = elf_names_table
    elif goblin == ancestry:
        table = goblin_names_table
    elif halfling == ancestry:
        table = halfling_names_table
    elif half_orc == ancestry:
        table = half_orc_names_table
    elif human == ancestry:
        table = human_names_table
    else:
        raise RuntimeError(f'Unsupported ancestry {ancestry}')

    return table.roll(rng)


dwarf_names_table = Table.with_values(
    'Hilde',
    'Torbin',
    'Marga',
    'Bruno',
    'Karina',
    'Naugrim',
    'Brenna',
    'Darvin',
    'Elga',
    'Alric',
    'Isolde',
    'Gendry',
    'Bruga',
    'Junnor',
    'Vidrid',
    'Torson',
    'Brielle',
    'Ulfgar',
    'Sarna',
    'Grimm',
)

elf_names_table = Table.with_values(
    'Eliara',
    'Ryarn',
    'Sariel',
    'Tirolas',
    'Galira',
    'Varos',
    'Daeniel',
    'Axidor',
    'Hiralia',
    'Cyrwin',
    'Lothiel',
    'Zaphiel',
    'Nayra',
    'Ithior',
    'Amriel',
    'Elyon',
    'Jirwyn',
    'Natinel',
    'Fiora',
    'Ruhiel',
)

goblin_names_table = Table.with_values(
    'Iggs',
    'Tark',
    'Nix',
    'Lenk',
    'Roke',
    'Fitz',
    'Tila',
    'Riggs',
    'Prim',
    'Zeb',
    'Finn',
    'Borg',
    'Yark',
    'Deeg',
    'Nibs',
    'Brak',
    'Fink',
    'Rizzo',
    'Squib',
    'Grix',
)

halfling_names_table = Table.with_values(
    'Willow',
    'Benny',
    'Annie',
    'Tucker',
    'Marie',
    'Hobb',
    'Cora',
    'Gordie',
    'Rose',
    'Ardo',
    'Alma',
    'Norbert',
    'Jennie',
    'Barvin',
    'Tilly',
    'Pike',
    'Lydia',
    'Marlow',
    'Astrid',
    'Jasper',
)

half_orc_names_table = Table.with_values(
    'Vara',
    'Gralk',
    'Ranna',
    'Korv',
    'Zasha',
    'Hrogar',
    'Klara',
    'Tragan',
    'Brolga',
    'Drago',
    'Yelena',
    'Krull',
    'Ulara',
    'Tulk',
    'Shiraal',
    'Wulf',
    'Ivara',
    'Hirok',
    'Aja',
    'Zoraan',
)

human_names_table = Table.with_values(
    'Zali',
    'Bram',
    'Clara',
    'Nattias',
    'Rina',
    'Denton',
    'Mirena',
    'Aran',
    'Morgan',
    'Giralt',
    'Tamra',
    'Oscar',
    'Ishana',
    'Rogar',
    'Jasmin',
    'Tarin',
    'Yuri',
    'Malchor',
    'Lienna',
    'Godfrey',
)
