from ndice import RNG

from ..characters import Character, RollHP, RollStats
from .random_first_level import random_first_level
from .random_zero_level import random_zero_level


def random_character(
    rng: RNG, roll_stats: RollStats, roll_hp: RollHP, level: int
) -> Character:
    assert level >= 0

    if 0 == level:
        return random_zero_level(rng, roll_stats, roll_hp)
    elif 1 == level:
        return random_first_level(rng, roll_stats, roll_hp)
    else:
        raise RuntimeError(f'Level {level} random characters not supported')
