from ndice import RNG

from ..characters import background_table, Character, RollHP, RollStats
from ..gear import Inventory
from .alignment_and_deity import roll_alignment_and_deity
from .ancestry_table import ancestry_table
from .choose_talents import choose_talents
from .gender_table import gender_table
from .languages import roll_ancestry_languages, roll_profession_languages
from .name import roll_name
from .profession_table import profession_table
from .starting_armor import get_starting_armor
from .starting_gear import get_starting_gear
from .starting_spells import roll_starting_spells
from .starting_weapon import roll_starting_weapon


# Starting Level, SD v4.8, p14
def random_first_level(
    rng: RNG,
    roll_stats: RollStats,
    roll_hp: RollHP,
) -> Character:
    stren, dex, con, intel, wis, cha = roll_stats(rng)
    gender = gender_table.roll(rng)

    ancestry = ancestry_table.roll(rng)
    name = roll_name(rng, ancestry)
    ancestry_languages = roll_ancestry_languages(rng, ancestry)
    ancestry_talent = ancestry.talent

    profession = profession_table.roll(rng)
    level = 1
    profession_languages = roll_profession_languages(
        rng, profession, ancestry_languages
    )
    languages = ancestry_languages + profession_languages
    spells = roll_starting_spells(rng, profession)
    talents = [ancestry_talent] + profession.talents

    hp = roll_hp(rng, level, profession, con, talents)

    background = background_table.roll(rng)
    alignment, deity = roll_alignment_and_deity(rng, profession)

    weapon = roll_starting_weapon(rng, profession)
    armor = get_starting_armor(profession)
    gear = get_starting_gear(profession)

    inventory = Inventory()
    inventory.add(weapon, armor, gear)

    character = Character(
        name=name,
        ancestry=ancestry,
        gender=gender,
        alignment=alignment,
        background=background,
        deity=deity,
        profession=profession,
        level=level,
        stren=stren,
        dex=dex,
        con=con,
        intel=intel,
        wis=wis,
        cha=cha,
        hp=hp,
        xp=0,
        languages=languages,
        talents=talents,
        spells=spells,
        inventory=inventory,
    )

    choose_talents(rng, character)

    return character
