from ndice import d4, RNG, roll

from ..characters import background_table, Character, RollHP, RollStats
from ..gear import Inventory
from .alignment_table import alignment_table
from .ancestry_table import ancestry_table
from .choose_talents import choose_talents
from .deity_table import deity_table
from .gender_table import gender_table
from .languages import roll_ancestry_languages
from .name import roll_name
from .starting_gear import starting_gear_table


# Starting Level, SD v4.8, p14
def random_zero_level(
    rng: RNG,
    roll_stats: RollStats,
    roll_hp: RollHP,
) -> Character:
    stren, dex, con, intel, wis, cha = roll_stats(rng)
    gender = gender_table.roll(rng)

    ancestry = ancestry_table.roll(rng)
    name = roll_name(rng, ancestry)
    languages = roll_ancestry_languages(rng, ancestry)
    ancestry_talent = ancestry.talent

    profession = None
    level = 0
    talents = [ancestry_talent]

    hp = roll_hp(rng, 0, None, con, talents)

    alignment = alignment_table.roll(rng)
    background = background_table.roll(rng)
    deity = deity_table.roll(rng)

    inventory = Inventory()
    count = roll(rng, d4)
    for _ in range(count):
        gear_items = starting_gear_table.roll(rng)
        inventory.add(gear_items)

    character = Character(
        name=name,
        ancestry=ancestry,
        gender=gender,
        alignment=alignment,
        background=background,
        deity=deity,
        profession=profession,
        level=level,
        stren=stren,
        dex=dex,
        con=con,
        intel=intel,
        wis=wis,
        cha=cha,
        hp=hp,
        xp=0,
        languages=languages,
        talents=[ancestry_talent],
        spells=[],
        inventory=inventory,
    )

    choose_talents(rng, character)

    return character
