from ..characters import priest, Profession, thief
from ..gear import arrow, caltrops, club, crawling_kit, crowbar, dagger
from ..gear import flint_and_steel, Gear, GearList, gold_piece, grappling_hook
from ..gear import holy_symbol, iron_spike, oil_flask, pole, rope, shortbow
from ..gear import thievery_tools, torch
from ..tables import Table


# Priest Class, "Deity", SD v4.8, p20
# Thief Class, "Thievery", SD v4.8, p20
# Gear, SD v4.8, p41
def get_starting_gear(profession: Profession) -> GearList:
    if thief == profession:
        return [crawling_kit, 5 * gold_piece, thievery_tools]
    elif priest == profession:
        return [crawling_kit, 5 * gold_piece, holy_symbol]
    else:
        return [crawling_kit, 5 * gold_piece]


# Gear table, SD v4.8, p33 and p41
starting_gear_table: Table[list[Gear]] = Table.with_values(
    [torch],
    [dagger],
    [pole],
    [shortbow, 5 * arrow],
    [60 * rope],
    [oil_flask],
    [crowbar],
    [10 * iron_spike],
    [flint_and_steel],
    [grappling_hook],
    [club],
    [caltrops],
)
