from ndice import RNG

from ..characters import alarm, burning_hands, charm_person, cure_wounds
from ..characters import detect_magic, feather_fall, floating_disk
from ..characters import hold_portal, holy_weapon, light, mage_armor
from ..characters import magic_missile, priest, Profession
from ..characters import protection_from_evil, shield_of_faith, sleep, Spell
from ..characters import turn_undead, wizard
from ..tables import Table


# Priest Spells, SD v4.8, p40
priest_spells_table = Table.with_values(
    light, cure_wounds, holy_weapon, protection_from_evil, shield_of_faith
)

# Wizard Spells, SD v4.8, p41
wizard_spells_table = Table.with_values(
    alarm,
    burning_hands,
    charm_person,
    detect_magic,
    feather_fall,
    floating_disk,
    hold_portal,
    light,
    mage_armor,
    magic_missile,
    protection_from_evil,
    sleep,
)


def roll_starting_spells(rng: RNG, profession: Profession) -> list[Spell]:
    if priest == profession:
        return [turn_undead] + priest_spells_table.pick(rng, 2)
    elif wizard == profession:
        return wizard_spells_table.pick(rng, 3)
    else:
        return []
