from ndice import RNG

from ..characters import Profession
from ..gear import arrow, crossbow, crossbow_bolt, Gear, longbow, shortbow
from ..gear import Weapon
from ..tables import Table


def add_ammo(weapon: Weapon) -> list[Gear]:
    if crossbow == weapon:
        return [crossbow, 5 * crossbow_bolt]
    elif weapon in [longbow, shortbow]:
        return [weapon, 5 * arrow]
    else:
        return [weapon]


def roll_starting_weapon(rng: RNG, profession: Profession) -> list[Gear]:
    table = Table.with_values(*profession.weapons)
    return add_ammo(table.roll(rng))
