from __future__ import annotations

from dataclasses import dataclass
from typing import TypeVar


T = TypeVar('T')
type RangedValue[T] = tuple[int, T] | tuple[int, int, T]


@dataclass(frozen=True, slots=True)
class Row[T]:
    value: T
    weight: int

    def __post_init__(self) -> None:
        assert self.weight > 0

    @classmethod
    def from_ranged_value(cls, ranged_value: RangedValue[T]) -> Row[T]:
        if 2 == len(ranged_value):
            die_roll, value = ranged_value
            weight = 1
        else:
            low_roll, high_roll, value = ranged_value
            weight = high_roll - low_roll + 1
        return Row(value, weight)
