"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LookUpEips = exports.handler = void 0;
const client_ec2_1 = require("@aws-sdk/client-ec2");
async function handler(event) {
    console.log({ ...event, ResponseURL: '...' });
    const companyIps = event.ResourceProperties.COMPANY_IPS;
    const stackName = event.ResourceProperties.STACK_NAME;
    const regionList = event.ResourceProperties.REGIONS;
    let ipList = [];
    if (companyIps) {
        try {
            const companyIpsList = JSON.parse(companyIps);
            companyIpsList.forEach(ip => {
                if (ip.includes('/32')) {
                    ipList.push(`${ip}`);
                }
                else {
                    ipList.push(`${ip}/32`);
                }
            });
        }
        catch (e) {
            console.log(e);
        }
    }
    if (regionList) {
        return LookUpEips(regionList, ipList, stackName);
    }
    return {
        PhysicalResourceId: `Custom::GetEIP${stackName}`,
        Data: {
            IP_LIST: ipList,
        },
    };
}
exports.handler = handler;
async function LookUpEips(regionList, ipList, stackName) {
    try {
        const regionListJson = JSON.parse(regionList);
        let promises = [];
        for (const region of regionListJson) {
            console.log('Now Run region: ', region);
            const client = new client_ec2_1.EC2Client({ region: region });
            promises.push(client.send(new client_ec2_1.DescribeAddressesCommand({})));
        }
        const addresses = await Promise.all(promises);
        for (const address of addresses) {
            if (address.Addresses) {
                for (const ip of address.Addresses) {
                    ipList.push(`${ip.PublicIp}/32`);
                }
            }
        }
        console.log('lookupEips', ipList);
        const uniqIpList = [...new Set(ipList)];
        console.log('Unit Ips Values', uniqIpList);
        return {
            PhysicalResourceId: `Custom::GetEIP${stackName}`,
            Data: {
                IP_LIST: uniqIpList,
            },
        };
    }
    catch (e) {
        console.log(e);
        throw e;
    }
}
exports.LookUpEips = LookUpEips;
//# sourceMappingURL=data:application/json;base64,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