"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomResourceGetEIP = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class CustomResourceGetEIP extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const onEvent = new aws_cdk_lib_1.aws_lambda_nodejs.NodejsFunction(this, `${id}GetEIP`, {
            entry: fs.existsSync(path.join(__dirname, 'lambda/get-eip-handler.ts')) ? path.join(__dirname, 'lambda/get-eip-handler.ts') : path.join(__dirname, 'lambda/get-eip-handler.js'),
            handler: 'handler',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_16_X,
            bundling: {
                forceDockerBundling: false,
                minify: true,
            },
        });
        const myProvider = new aws_cdk_lib_1.custom_resources.Provider(this, `${id}MyProvider`, {
            onEventHandler: onEvent,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_DAY,
        });
        onEvent.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            actions: ['ec2:DescribeAddresses'],
            resources: ['*'],
        }));
        if (props?.regions) {
            let right_regions = [];
            aws_cdk_lib_1.region_info.RegionInfo.regions.forEach(r => {
                right_regions.push(r.name);
            });
            props.regions.forEach(r => {
                if (!right_regions.includes(r)) {
                    throw new Error(`Fault region code ${r}`);
                }
            });
        }
        this.outputs = new aws_cdk_lib_1.CustomResource(this, `${id}CustomGetEIP`, {
            resourceType: 'Custom::GetEIP',
            serviceToken: myProvider.serviceToken,
            properties: {
                STACK_NAME: aws_cdk_lib_1.Stack.of(this).stackName,
                COMPANY_IPS: aws_cdk_lib_1.Stack.of(this).toJsonString(props?.companyIps),
                REGIONS: aws_cdk_lib_1.Stack.of(this).toJsonString(props?.regions),
                randomString: props?.alwaysUpdate === false ? undefined : randomString(),
            },
        });
    }
    /**
     *
     * @returns Token.asList(this.outputs.getAtt('IP_LIST'));
     *
     */
    ipList() {
        return aws_cdk_lib_1.Token.asList(this.outputs.getAtt('IP_LIST'));
    }
}
_a = JSII_RTTI_SYMBOL_1;
CustomResourceGetEIP[_a] = { fqn: "cdk-cr-constructs.CustomResourceGetEIP", version: "2.1.398" };
exports.CustomResourceGetEIP = CustomResourceGetEIP;
function randomString() {
    // Crazy
    return Math.random().toString(36).replace(/[^a-z0-9]+/g, '');
}
//# sourceMappingURL=data:application/json;base64,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