import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { DescribeConversionTasksResultFilterSensitiveLog, } from "../models/models_3";
import { de_DescribeConversionTasksCommand, se_DescribeConversionTasksCommand } from "../protocols/Aws_ec2";
export { $Command };
export class DescribeConversionTasksCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2", "DescribeConversionTasks", {})
    .n("EC2Client", "DescribeConversionTasksCommand")
    .f(void 0, DescribeConversionTasksResultFilterSensitiveLog)
    .ser(se_DescribeConversionTasksCommand)
    .de(de_DescribeConversionTasksCommand)
    .build() {
}
