import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { DescribeLaunchTemplateVersionsResultFilterSensitiveLog, } from "../models/models_4";
import { de_DescribeLaunchTemplateVersionsCommand, se_DescribeLaunchTemplateVersionsCommand, } from "../protocols/Aws_ec2";
export { $Command };
export class DescribeLaunchTemplateVersionsCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AmazonEC2", "DescribeLaunchTemplateVersions", {})
    .n("EC2Client", "DescribeLaunchTemplateVersionsCommand")
    .f(void 0, DescribeLaunchTemplateVersionsResultFilterSensitiveLog)
    .ser(se_DescribeLaunchTemplateVersionsCommand)
    .de(de_DescribeLaunchTemplateVersionsCommand)
    .build() {
}
