import { SENSITIVE_STRING } from "@smithy/smithy-client";
export const CarrierGatewayState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const ClientVpnAuthenticationType = {
    certificate_authentication: "certificate-authentication",
    directory_service_authentication: "directory-service-authentication",
    federated_authentication: "federated-authentication",
};
export const SelfServicePortal = {
    disabled: "disabled",
    enabled: "enabled",
};
export const TransportProtocol = {
    tcp: "tcp",
    udp: "udp",
};
export const ClientVpnEndpointStatusCode = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending_associate: "pending-associate",
};
export const ClientVpnRouteStatusCode = {
    active: "active",
    creating: "creating",
    deleting: "deleting",
    failed: "failed",
};
export const GatewayType = {
    ipsec_1: "ipsec.1",
};
export const HostnameType = {
    ip_name: "ip-name",
    resource_name: "resource-name",
};
export const SubnetState = {
    available: "available",
    pending: "pending",
    unavailable: "unavailable",
};
export const Tenancy = {
    dedicated: "dedicated",
    default: "default",
    host: "host",
};
export const VpcState = {
    available: "available",
    pending: "pending",
};
export const FleetExcessCapacityTerminationPolicy = {
    NO_TERMINATION: "no-termination",
    TERMINATION: "termination",
};
export const BareMetal = {
    EXCLUDED: "excluded",
    INCLUDED: "included",
    REQUIRED: "required",
};
export const BurstablePerformance = {
    EXCLUDED: "excluded",
    INCLUDED: "included",
    REQUIRED: "required",
};
export const CpuManufacturer = {
    AMAZON_WEB_SERVICES: "amazon-web-services",
    AMD: "amd",
    INTEL: "intel",
};
export const InstanceGeneration = {
    CURRENT: "current",
    PREVIOUS: "previous",
};
export const LocalStorage = {
    EXCLUDED: "excluded",
    INCLUDED: "included",
    REQUIRED: "required",
};
export const LocalStorageType = {
    HDD: "hdd",
    SSD: "ssd",
};
export const FleetOnDemandAllocationStrategy = {
    LOWEST_PRICE: "lowest-price",
    PRIORITIZED: "prioritized",
};
export const FleetCapacityReservationUsageStrategy = {
    USE_CAPACITY_RESERVATIONS_FIRST: "use-capacity-reservations-first",
};
export const SpotAllocationStrategy = {
    CAPACITY_OPTIMIZED: "capacity-optimized",
    CAPACITY_OPTIMIZED_PRIORITIZED: "capacity-optimized-prioritized",
    DIVERSIFIED: "diversified",
    LOWEST_PRICE: "lowest-price",
    PRICE_CAPACITY_OPTIMIZED: "price-capacity-optimized",
};
export const SpotInstanceInterruptionBehavior = {
    hibernate: "hibernate",
    stop: "stop",
    terminate: "terminate",
};
export const FleetReplacementStrategy = {
    LAUNCH: "launch",
    LAUNCH_BEFORE_TERMINATE: "launch-before-terminate",
};
export const DefaultTargetCapacityType = {
    CAPACITY_BLOCK: "capacity-block",
    ON_DEMAND: "on-demand",
    SPOT: "spot",
};
export const TargetCapacityUnitType = {
    MEMORY_MIB: "memory-mib",
    UNITS: "units",
    VCPU: "vcpu",
};
export const FleetType = {
    INSTANT: "instant",
    MAINTAIN: "maintain",
    REQUEST: "request",
};
export const InstanceLifecycle = {
    ON_DEMAND: "on-demand",
    SPOT: "spot",
};
export const PlatformValues = {
    Windows: "Windows",
};
export const DestinationFileFormat = {
    parquet: "parquet",
    plain_text: "plain-text",
};
export const LogDestinationType = {
    cloud_watch_logs: "cloud-watch-logs",
    kinesis_data_firehose: "kinesis-data-firehose",
    s3: "s3",
};
export const FlowLogsResourceType = {
    NetworkInterface: "NetworkInterface",
    Subnet: "Subnet",
    TransitGateway: "TransitGateway",
    TransitGatewayAttachment: "TransitGatewayAttachment",
    VPC: "VPC",
};
export const TrafficType = {
    ACCEPT: "ACCEPT",
    ALL: "ALL",
    REJECT: "REJECT",
};
export const VolumeType = {
    gp2: "gp2",
    gp3: "gp3",
    io1: "io1",
    io2: "io2",
    sc1: "sc1",
    st1: "st1",
    standard: "standard",
};
export const Ec2InstanceConnectEndpointState = {
    create_complete: "create-complete",
    create_failed: "create-failed",
    create_in_progress: "create-in-progress",
    delete_complete: "delete-complete",
    delete_failed: "delete-failed",
    delete_in_progress: "delete-in-progress",
};
export const ContainerFormat = {
    ova: "ova",
};
export const DiskImageFormat = {
    RAW: "RAW",
    VHD: "VHD",
    VMDK: "VMDK",
};
export const ExportEnvironment = {
    citrix: "citrix",
    microsoft: "microsoft",
    vmware: "vmware",
};
export const ExportTaskState = {
    active: "active",
    cancelled: "cancelled",
    cancelling: "cancelling",
    completed: "completed",
};
export const IpamTier = {
    advanced: "advanced",
    free: "free",
};
export const IpamState = {
    create_complete: "create-complete",
    create_failed: "create-failed",
    create_in_progress: "create-in-progress",
    delete_complete: "delete-complete",
    delete_failed: "delete-failed",
    delete_in_progress: "delete-in-progress",
    isolate_complete: "isolate-complete",
    isolate_in_progress: "isolate-in-progress",
    modify_complete: "modify-complete",
    modify_failed: "modify-failed",
    modify_in_progress: "modify-in-progress",
    restore_in_progress: "restore-in-progress",
};
export const IpamPoolAwsService = {
    ec2: "ec2",
};
export const IpamPoolPublicIpSource = {
    amazon: "amazon",
    byoip: "byoip",
};
export const IpamPoolSourceResourceType = {
    vpc: "vpc",
};
export const IpamScopeType = {
    private: "private",
    public: "public",
};
export const IpamPoolState = {
    create_complete: "create-complete",
    create_failed: "create-failed",
    create_in_progress: "create-in-progress",
    delete_complete: "delete-complete",
    delete_failed: "delete-failed",
    delete_in_progress: "delete-in-progress",
    isolate_complete: "isolate-complete",
    isolate_in_progress: "isolate-in-progress",
    modify_complete: "modify-complete",
    modify_failed: "modify-failed",
    modify_in_progress: "modify-in-progress",
    restore_in_progress: "restore-in-progress",
};
export const IpamResourceDiscoveryState = {
    CREATE_COMPLETE: "create-complete",
    CREATE_FAILED: "create-failed",
    CREATE_IN_PROGRESS: "create-in-progress",
    DELETE_COMPLETE: "delete-complete",
    DELETE_FAILED: "delete-failed",
    DELETE_IN_PROGRESS: "delete-in-progress",
    ISOLATE_COMPLETE: "isolate-complete",
    ISOLATE_IN_PROGRESS: "isolate-in-progress",
    MODIFY_COMPLETE: "modify-complete",
    MODIFY_FAILED: "modify-failed",
    MODIFY_IN_PROGRESS: "modify-in-progress",
    RESTORE_IN_PROGRESS: "restore-in-progress",
};
export const IpamScopeState = {
    create_complete: "create-complete",
    create_failed: "create-failed",
    create_in_progress: "create-in-progress",
    delete_complete: "delete-complete",
    delete_failed: "delete-failed",
    delete_in_progress: "delete-in-progress",
    isolate_complete: "isolate-complete",
    isolate_in_progress: "isolate-in-progress",
    modify_complete: "modify-complete",
    modify_failed: "modify-failed",
    modify_in_progress: "modify-in-progress",
    restore_in_progress: "restore-in-progress",
};
export const KeyFormat = {
    pem: "pem",
    ppk: "ppk",
};
export const KeyType = {
    ed25519: "ed25519",
    rsa: "rsa",
};
export const CapacityReservationPreference = {
    none: "none",
    open: "open",
};
export const AmdSevSnpSpecification = {
    disabled: "disabled",
    enabled: "enabled",
};
export const ShutdownBehavior = {
    stop: "stop",
    terminate: "terminate",
};
export const MarketType = {
    capacity_block: "capacity-block",
    spot: "spot",
};
export const InstanceInterruptionBehavior = {
    hibernate: "hibernate",
    stop: "stop",
    terminate: "terminate",
};
export const SpotInstanceType = {
    one_time: "one-time",
    persistent: "persistent",
};
export const LaunchTemplateAutoRecoveryState = {
    default: "default",
    disabled: "disabled",
};
export const LaunchTemplateInstanceMetadataEndpointState = {
    disabled: "disabled",
    enabled: "enabled",
};
export const LaunchTemplateInstanceMetadataProtocolIpv6 = {
    disabled: "disabled",
    enabled: "enabled",
};
export const LaunchTemplateHttpTokensState = {
    optional: "optional",
    required: "required",
};
export const LaunchTemplateInstanceMetadataTagsState = {
    disabled: "disabled",
    enabled: "enabled",
};
export const LaunchTemplateInstanceMetadataOptionsState = {
    applied: "applied",
    pending: "pending",
};
export const LocalGatewayRouteState = {
    active: "active",
    blackhole: "blackhole",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const LocalGatewayRouteType = {
    propagated: "propagated",
    static: "static",
};
export const LocalGatewayRouteTableMode = {
    coip: "coip",
    direct_vpc_routing: "direct-vpc-routing",
};
export const PrefixListState = {
    create_complete: "create-complete",
    create_failed: "create-failed",
    create_in_progress: "create-in-progress",
    delete_complete: "delete-complete",
    delete_failed: "delete-failed",
    delete_in_progress: "delete-in-progress",
    modify_complete: "modify-complete",
    modify_failed: "modify-failed",
    modify_in_progress: "modify-in-progress",
    restore_complete: "restore-complete",
    restore_failed: "restore-failed",
    restore_in_progress: "restore-in-progress",
};
export const ConnectivityType = {
    PRIVATE: "private",
    PUBLIC: "public",
};
export const NatGatewayState = {
    AVAILABLE: "available",
    DELETED: "deleted",
    DELETING: "deleting",
    FAILED: "failed",
    PENDING: "pending",
};
export const RuleAction = {
    allow: "allow",
    deny: "deny",
};
export const NetworkInterfaceCreationType = {
    branch: "branch",
    efa: "efa",
    trunk: "trunk",
};
export const NetworkInterfaceType = {
    api_gateway_managed: "api_gateway_managed",
    aws_codestar_connections_managed: "aws_codestar_connections_managed",
    branch: "branch",
    efa: "efa",
    gateway_load_balancer: "gateway_load_balancer",
    gateway_load_balancer_endpoint: "gateway_load_balancer_endpoint",
    global_accelerator_managed: "global_accelerator_managed",
    interface: "interface",
    iot_rules_managed: "iot_rules_managed",
    lambda: "lambda",
    load_balancer: "load_balancer",
    natGateway: "natGateway",
    network_load_balancer: "network_load_balancer",
    quicksight: "quicksight",
    transit_gateway: "transit_gateway",
    trunk: "trunk",
    vpc_endpoint: "vpc_endpoint",
};
export const KeyPairFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.KeyMaterial && { KeyMaterial: SENSITIVE_STRING }),
});
export const RequestLaunchTemplateDataFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserData && { UserData: SENSITIVE_STRING }),
});
export const CreateLaunchTemplateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchTemplateData && {
        LaunchTemplateData: RequestLaunchTemplateDataFilterSensitiveLog(obj.LaunchTemplateData),
    }),
});
export const CreateLaunchTemplateVersionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchTemplateData && {
        LaunchTemplateData: RequestLaunchTemplateDataFilterSensitiveLog(obj.LaunchTemplateData),
    }),
});
export const ResponseLaunchTemplateDataFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserData && { UserData: SENSITIVE_STRING }),
});
export const LaunchTemplateVersionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchTemplateData && {
        LaunchTemplateData: ResponseLaunchTemplateDataFilterSensitiveLog(obj.LaunchTemplateData),
    }),
});
export const CreateLaunchTemplateVersionResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchTemplateVersion && {
        LaunchTemplateVersion: LaunchTemplateVersionFilterSensitiveLog(obj.LaunchTemplateVersion),
    }),
});
