import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { VerifiedAccessTrustProviderFilterSensitiveLog, } from "./models_0";
export const NetworkInterfaceStatus = {
    associated: "associated",
    attaching: "attaching",
    available: "available",
    detaching: "detaching",
    in_use: "in-use",
};
export const InterfacePermissionType = {
    EIP_ASSOCIATE: "EIP-ASSOCIATE",
    INSTANCE_ATTACH: "INSTANCE-ATTACH",
};
export const NetworkInterfacePermissionStateCode = {
    granted: "granted",
    pending: "pending",
    revoked: "revoked",
    revoking: "revoking",
};
export const SpreadLevel = {
    host: "host",
    rack: "rack",
};
export const PlacementStrategy = {
    cluster: "cluster",
    partition: "partition",
    spread: "spread",
};
export const PlacementGroupState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const ReplaceRootVolumeTaskState = {
    failed: "failed",
    failed_detached: "failed-detached",
    failing: "failing",
    in_progress: "in-progress",
    pending: "pending",
    succeeded: "succeeded",
};
export const RouteOrigin = {
    CreateRoute: "CreateRoute",
    CreateRouteTable: "CreateRouteTable",
    EnableVgwRoutePropagation: "EnableVgwRoutePropagation",
};
export const RouteState = {
    active: "active",
    blackhole: "blackhole",
};
export const SSEType = {
    none: "none",
    sse_ebs: "sse-ebs",
    sse_kms: "sse-kms",
};
export const SnapshotState = {
    completed: "completed",
    error: "error",
    pending: "pending",
    recoverable: "recoverable",
    recovering: "recovering",
};
export const StorageTier = {
    archive: "archive",
    standard: "standard",
};
export const CopyTagsFromSource = {
    volume: "volume",
};
export const DatafeedSubscriptionState = {
    Active: "Active",
    Inactive: "Inactive",
};
export const SubnetCidrReservationType = {
    explicit: "explicit",
    prefix: "prefix",
};
export const TrafficMirrorRuleAction = {
    accept: "accept",
    reject: "reject",
};
export const TrafficDirection = {
    egress: "egress",
    ingress: "ingress",
};
export const TrafficMirrorNetworkService = {
    amazon_dns: "amazon-dns",
};
export const TrafficMirrorTargetType = {
    gateway_load_balancer_endpoint: "gateway-load-balancer-endpoint",
    network_interface: "network-interface",
    network_load_balancer: "network-load-balancer",
};
export const AutoAcceptSharedAttachmentsValue = {
    disable: "disable",
    enable: "enable",
};
export const DefaultRouteTableAssociationValue = {
    disable: "disable",
    enable: "enable",
};
export const DefaultRouteTablePropagationValue = {
    disable: "disable",
    enable: "enable",
};
export const MulticastSupportValue = {
    disable: "disable",
    enable: "enable",
};
export const VpnEcmpSupportValue = {
    disable: "disable",
    enable: "enable",
};
export const TransitGatewayState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    modifying: "modifying",
    pending: "pending",
};
export const ProtocolValue = {
    gre: "gre",
};
export const BgpStatus = {
    down: "down",
    up: "up",
};
export const TransitGatewayConnectPeerState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const AutoAcceptSharedAssociationsValue = {
    disable: "disable",
    enable: "enable",
};
export const Igmpv2SupportValue = {
    disable: "disable",
    enable: "enable",
};
export const StaticSourcesSupportValue = {
    disable: "disable",
    enable: "enable",
};
export const TransitGatewayMulticastDomainState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const TransitGatewayPolicyTableState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const TransitGatewayPrefixListReferenceState = {
    available: "available",
    deleting: "deleting",
    modifying: "modifying",
    pending: "pending",
};
export const TransitGatewayRouteState = {
    active: "active",
    blackhole: "blackhole",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const TransitGatewayRouteType = {
    propagated: "propagated",
    static: "static",
};
export const TransitGatewayRouteTableState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const TransitGatewayRouteTableAnnouncementDirection = {
    incoming: "incoming",
    outgoing: "outgoing",
};
export const TransitGatewayRouteTableAnnouncementState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    failed: "failed",
    failing: "failing",
    pending: "pending",
};
export const VerifiedAccessEndpointAttachmentType = {
    vpc: "vpc",
};
export const VerifiedAccessEndpointType = {
    load_balancer: "load-balancer",
    network_interface: "network-interface",
};
export const VerifiedAccessEndpointProtocol = {
    http: "http",
    https: "https",
};
export const VerifiedAccessEndpointStatusCode = {
    active: "active",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
    updating: "updating",
};
export const VolumeState = {
    available: "available",
    creating: "creating",
    deleted: "deleted",
    deleting: "deleting",
    error: "error",
    in_use: "in-use",
};
export const DnsRecordIpType = {
    dualstack: "dualstack",
    ipv4: "ipv4",
    ipv6: "ipv6",
    service_defined: "service-defined",
};
export const IpAddressType = {
    dualstack: "dualstack",
    ipv4: "ipv4",
    ipv6: "ipv6",
};
export const VpcEndpointType = {
    Gateway: "Gateway",
    GatewayLoadBalancer: "GatewayLoadBalancer",
    Interface: "Interface",
};
export const State = {
    Available: "Available",
    Deleted: "Deleted",
    Deleting: "Deleting",
    Expired: "Expired",
    Failed: "Failed",
    Pending: "Pending",
    PendingAcceptance: "PendingAcceptance",
    Rejected: "Rejected",
};
export const ConnectionNotificationState = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
export const ConnectionNotificationType = {
    Topic: "Topic",
};
export const PayerResponsibility = {
    ServiceOwner: "ServiceOwner",
};
export const DnsNameState = {
    Failed: "failed",
    PendingVerification: "pendingVerification",
    Verified: "verified",
};
export const ServiceState = {
    Available: "Available",
    Deleted: "Deleted",
    Deleting: "Deleting",
    Failed: "Failed",
    Pending: "Pending",
};
export const ServiceType = {
    Gateway: "Gateway",
    GatewayLoadBalancer: "GatewayLoadBalancer",
    Interface: "Interface",
};
export const ServiceConnectivityType = {
    ipv4: "ipv4",
    ipv6: "ipv6",
};
export const TunnelInsideIpVersion = {
    ipv4: "ipv4",
    ipv6: "ipv6",
};
export const GatewayAssociationState = {
    associated: "associated",
    associating: "associating",
    disassociating: "disassociating",
    not_associated: "not-associated",
};
export const VpnStaticRouteSource = {
    Static: "Static",
};
export const VpnState = {
    available: "available",
    deleted: "deleted",
    deleting: "deleting",
    pending: "pending",
};
export const TelemetryStatus = {
    DOWN: "DOWN",
    UP: "UP",
};
export const FleetStateCode = {
    ACTIVE: "active",
    DELETED: "deleted",
    DELETED_RUNNING: "deleted_running",
    DELETED_TERMINATING_INSTANCES: "deleted_terminating",
    FAILED: "failed",
    MODIFYING: "modifying",
    SUBMITTED: "submitted",
};
export const DeleteFleetErrorCode = {
    FLEET_ID_DOES_NOT_EXIST: "fleetIdDoesNotExist",
    FLEET_ID_MALFORMED: "fleetIdMalformed",
    FLEET_NOT_IN_DELETABLE_STATE: "fleetNotInDeletableState",
    UNEXPECTED_ERROR: "unexpectedError",
};
export const LaunchTemplateErrorCode = {
    LAUNCH_TEMPLATE_ID_DOES_NOT_EXIST: "launchTemplateIdDoesNotExist",
    LAUNCH_TEMPLATE_ID_MALFORMED: "launchTemplateIdMalformed",
    LAUNCH_TEMPLATE_NAME_DOES_NOT_EXIST: "launchTemplateNameDoesNotExist",
    LAUNCH_TEMPLATE_NAME_MALFORMED: "launchTemplateNameMalformed",
    LAUNCH_TEMPLATE_VERSION_DOES_NOT_EXIST: "launchTemplateVersionDoesNotExist",
    UNEXPECTED_ERROR: "unexpectedError",
};
export const CreateVerifiedAccessTrustProviderOidcOptionsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ClientSecret && { ClientSecret: SENSITIVE_STRING }),
});
export const CreateVerifiedAccessTrustProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OidcOptions && {
        OidcOptions: CreateVerifiedAccessTrustProviderOidcOptionsFilterSensitiveLog(obj.OidcOptions),
    }),
});
export const CreateVerifiedAccessTrustProviderResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VerifiedAccessTrustProvider && {
        VerifiedAccessTrustProvider: VerifiedAccessTrustProviderFilterSensitiveLog(obj.VerifiedAccessTrustProvider),
    }),
});
export const VpnTunnelOptionsSpecificationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PreSharedKey && { PreSharedKey: SENSITIVE_STRING }),
});
export const VpnConnectionOptionsSpecificationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TunnelOptions && {
        TunnelOptions: obj.TunnelOptions.map((item) => VpnTunnelOptionsSpecificationFilterSensitiveLog(item)),
    }),
});
export const CreateVpnConnectionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Options && { Options: VpnConnectionOptionsSpecificationFilterSensitiveLog(obj.Options) }),
});
export const TunnelOptionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PreSharedKey && { PreSharedKey: SENSITIVE_STRING }),
});
export const VpnConnectionOptionsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TunnelOptions && { TunnelOptions: obj.TunnelOptions.map((item) => TunnelOptionFilterSensitiveLog(item)) }),
});
export const VpnConnectionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.CustomerGatewayConfiguration && { CustomerGatewayConfiguration: SENSITIVE_STRING }),
    ...(obj.Options && { Options: VpnConnectionOptionsFilterSensitiveLog(obj.Options) }),
});
export const CreateVpnConnectionResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VpnConnection && { VpnConnection: VpnConnectionFilterSensitiveLog(obj.VpnConnection) }),
});
