import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { BundleTaskFilterSensitiveLog, VerifiedAccessTrustProviderFilterSensitiveLog, } from "./models_0";
export const DeleteQueuedReservedInstancesErrorCode = {
    RESERVED_INSTANCES_ID_INVALID: "reserved-instances-id-invalid",
    RESERVED_INSTANCES_NOT_IN_QUEUED_STATE: "reserved-instances-not-in-queued-state",
    UNEXPECTED_ERROR: "unexpected-error",
};
export const AsnState = {
    deprovisioned: "deprovisioned",
    failed_deprovision: "failed-deprovision",
    failed_provision: "failed-provision",
    pending_deprovision: "pending-deprovision",
    pending_provision: "pending-provision",
    provisioned: "provisioned",
};
export const IpamPoolCidrFailureCode = {
    cidr_not_available: "cidr-not-available",
    limit_exceeded: "limit-exceeded",
};
export const IpamPoolCidrState = {
    deprovisioned: "deprovisioned",
    failed_deprovision: "failed-deprovision",
    failed_import: "failed-import",
    failed_provision: "failed-provision",
    pending_deprovision: "pending-deprovision",
    pending_import: "pending-import",
    pending_provision: "pending-provision",
    provisioned: "provisioned",
};
export const AvailabilityZoneOptInStatus = {
    not_opted_in: "not-opted-in",
    opt_in_not_required: "opt-in-not-required",
    opted_in: "opted-in",
};
export const AvailabilityZoneState = {
    available: "available",
    constrained: "constrained",
    impaired: "impaired",
    information: "information",
    unavailable: "unavailable",
};
export const MetricType = {
    aggregate_latency: "aggregate-latency",
};
export const PeriodType = {
    fifteen_minutes: "fifteen-minutes",
    five_minutes: "five-minutes",
    one_day: "one-day",
    one_hour: "one-hour",
    one_week: "one-week",
    three_hours: "three-hours",
};
export const StatisticType = {
    p50: "p50",
};
export const ClientVpnConnectionStatusCode = {
    active: "active",
    failed_to_terminate: "failed-to-terminate",
    terminated: "terminated",
    terminating: "terminating",
};
export const AssociatedNetworkType = {
    vpc: "vpc",
};
export const ClientVpnEndpointAttributeStatusCode = {
    applied: "applied",
    applying: "applying",
};
export const VpnProtocol = {
    openvpn: "openvpn",
};
export const ConversionTaskState = {
    active: "active",
    cancelled: "cancelled",
    cancelling: "cancelling",
    completed: "completed",
};
export const ElasticGpuStatus = {
    Impaired: "IMPAIRED",
    Ok: "OK",
};
export const ElasticGpuState = {
    Attached: "ATTACHED",
};
export const FastLaunchResourceType = {
    SNAPSHOT: "snapshot",
};
export const FastLaunchStateCode = {
    disabling: "disabling",
    disabling_failed: "disabling-failed",
    enabled: "enabled",
    enabled_failed: "enabled-failed",
    enabling: "enabling",
    enabling_failed: "enabling-failed",
};
export const FastSnapshotRestoreStateCode = {
    disabled: "disabled",
    disabling: "disabling",
    enabled: "enabled",
    enabling: "enabling",
    optimizing: "optimizing",
};
export const FleetEventType = {
    FLEET_CHANGE: "fleet-change",
    INSTANCE_CHANGE: "instance-change",
    SERVICE_ERROR: "service-error",
};
export const FleetActivityStatus = {
    ERROR: "error",
    FULFILLED: "fulfilled",
    PENDING_FULFILLMENT: "pending_fulfillment",
    PENDING_TERMINATION: "pending_termination",
};
export const FpgaImageAttributeName = {
    description: "description",
    loadPermission: "loadPermission",
    name: "name",
    productCodes: "productCodes",
};
export const PermissionGroup = {
    all: "all",
};
export const ProductCodeValues = {
    devpay: "devpay",
    marketplace: "marketplace",
};
export const FpgaImageStateCode = {
    available: "available",
    failed: "failed",
    pending: "pending",
    unavailable: "unavailable",
};
export const PaymentOption = {
    ALL_UPFRONT: "AllUpfront",
    NO_UPFRONT: "NoUpfront",
    PARTIAL_UPFRONT: "PartialUpfront",
};
export const ReservationState = {
    ACTIVE: "active",
    PAYMENT_FAILED: "payment-failed",
    PAYMENT_PENDING: "payment-pending",
    RETIRED: "retired",
};
export const ImageAttributeName = {
    blockDeviceMapping: "blockDeviceMapping",
    bootMode: "bootMode",
    description: "description",
    imdsSupport: "imdsSupport",
    kernel: "kernel",
    lastLaunchedTime: "lastLaunchedTime",
    launchPermission: "launchPermission",
    productCodes: "productCodes",
    ramdisk: "ramdisk",
    sriovNetSupport: "sriovNetSupport",
    tpmSupport: "tpmSupport",
    uefiData: "uefiData",
};
export const ArchitectureValues = {
    arm64: "arm64",
    arm64_mac: "arm64_mac",
    i386: "i386",
    x86_64: "x86_64",
    x86_64_mac: "x86_64_mac",
};
export const BootModeValues = {
    legacy_bios: "legacy-bios",
    uefi: "uefi",
    uefi_preferred: "uefi-preferred",
};
export const HypervisorType = {
    ovm: "ovm",
    xen: "xen",
};
export const ImageTypeValues = {
    kernel: "kernel",
    machine: "machine",
    ramdisk: "ramdisk",
};
export const ImdsSupportValues = {
    v2_0: "v2.0",
};
export const DeviceType = {
    ebs: "ebs",
    instance_store: "instance-store",
};
export const ImageState = {
    available: "available",
    deregistered: "deregistered",
    disabled: "disabled",
    error: "error",
    failed: "failed",
    invalid: "invalid",
    pending: "pending",
    transient: "transient",
};
export const TpmSupportValues = {
    v2_0: "v2.0",
};
export const VirtualizationType = {
    hvm: "hvm",
    paravirtual: "paravirtual",
};
export const DeleteVerifiedAccessTrustProviderResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VerifiedAccessTrustProvider && {
        VerifiedAccessTrustProvider: VerifiedAccessTrustProviderFilterSensitiveLog(obj.VerifiedAccessTrustProvider),
    }),
});
export const DescribeBundleTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.BundleTasks && { BundleTasks: obj.BundleTasks.map((item) => BundleTaskFilterSensitiveLog(item)) }),
});
export const DiskImageDescriptionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ImportManifestUrl && { ImportManifestUrl: SENSITIVE_STRING }),
});
export const ImportInstanceVolumeDetailItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Image && { Image: DiskImageDescriptionFilterSensitiveLog(obj.Image) }),
});
export const ImportInstanceTaskDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Volumes && { Volumes: obj.Volumes.map((item) => ImportInstanceVolumeDetailItemFilterSensitiveLog(item)) }),
});
export const ImportVolumeTaskDetailsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Image && { Image: DiskImageDescriptionFilterSensitiveLog(obj.Image) }),
});
export const ConversionTaskFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ImportInstance && { ImportInstance: ImportInstanceTaskDetailsFilterSensitiveLog(obj.ImportInstance) }),
    ...(obj.ImportVolume && { ImportVolume: ImportVolumeTaskDetailsFilterSensitiveLog(obj.ImportVolume) }),
});
export const DescribeConversionTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ConversionTasks && {
        ConversionTasks: obj.ConversionTasks.map((item) => ConversionTaskFilterSensitiveLog(item)),
    }),
});
export const SnapshotDetailFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Url && { Url: SENSITIVE_STRING }),
});
export const ImportImageTaskFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SnapshotDetails && {
        SnapshotDetails: obj.SnapshotDetails.map((item) => SnapshotDetailFilterSensitiveLog(item)),
    }),
});
export const DescribeImportImageTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
