import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { LaunchTemplateVersionFilterSensitiveLog, } from "./models_1";
export const InstanceAttributeName = {
    blockDeviceMapping: "blockDeviceMapping",
    disableApiStop: "disableApiStop",
    disableApiTermination: "disableApiTermination",
    ebsOptimized: "ebsOptimized",
    enaSupport: "enaSupport",
    enclaveOptions: "enclaveOptions",
    groupSet: "groupSet",
    instanceInitiatedShutdownBehavior: "instanceInitiatedShutdownBehavior",
    instanceType: "instanceType",
    kernel: "kernel",
    productCodes: "productCodes",
    ramdisk: "ramdisk",
    rootDeviceName: "rootDeviceName",
    sourceDestCheck: "sourceDestCheck",
    sriovNetSupport: "sriovNetSupport",
    userData: "userData",
};
export const InstanceBootModeValues = {
    legacy_bios: "legacy-bios",
    uefi: "uefi",
};
export const InstanceLifecycleType = {
    capacity_block: "capacity-block",
    scheduled: "scheduled",
    spot: "spot",
};
export const InstanceAutoRecoveryState = {
    default: "default",
    disabled: "disabled",
};
export const InstanceMetadataEndpointState = {
    disabled: "disabled",
    enabled: "enabled",
};
export const InstanceMetadataProtocolState = {
    disabled: "disabled",
    enabled: "enabled",
};
export const HttpTokensState = {
    optional: "optional",
    required: "required",
};
export const InstanceMetadataTagsState = {
    disabled: "disabled",
    enabled: "enabled",
};
export const InstanceMetadataOptionsState = {
    applied: "applied",
    pending: "pending",
};
export const MonitoringState = {
    disabled: "disabled",
    disabling: "disabling",
    enabled: "enabled",
    pending: "pending",
};
export const InstanceStateName = {
    pending: "pending",
    running: "running",
    shutting_down: "shutting-down",
    stopped: "stopped",
    stopping: "stopping",
    terminated: "terminated",
};
export const EventCode = {
    instance_reboot: "instance-reboot",
    instance_retirement: "instance-retirement",
    instance_stop: "instance-stop",
    system_maintenance: "system-maintenance",
    system_reboot: "system-reboot",
};
export const StatusName = {
    reachability: "reachability",
};
export const StatusType = {
    failed: "failed",
    initializing: "initializing",
    insufficient_data: "insufficient-data",
    passed: "passed",
};
export const SummaryStatus = {
    impaired: "impaired",
    initializing: "initializing",
    insufficient_data: "insufficient-data",
    not_applicable: "not-applicable",
    ok: "ok",
};
export const LocationType = {
    availability_zone: "availability-zone",
    availability_zone_id: "availability-zone-id",
    outpost: "outpost",
    region: "region",
};
export const EbsOptimizedSupport = {
    default: "default",
    supported: "supported",
    unsupported: "unsupported",
};
export const EbsEncryptionSupport = {
    supported: "supported",
    unsupported: "unsupported",
};
export const EbsNvmeSupport = {
    REQUIRED: "required",
    SUPPORTED: "supported",
    UNSUPPORTED: "unsupported",
};
export const InstanceTypeHypervisor = {
    NITRO: "nitro",
    XEN: "xen",
};
export const DiskType = {
    hdd: "hdd",
    ssd: "ssd",
};
export const InstanceStorageEncryptionSupport = {
    required: "required",
    unsupported: "unsupported",
};
export const EphemeralNvmeSupport = {
    REQUIRED: "required",
    SUPPORTED: "supported",
    UNSUPPORTED: "unsupported",
};
export const EnaSupport = {
    required: "required",
    supported: "supported",
    unsupported: "unsupported",
};
export const NitroEnclavesSupport = {
    SUPPORTED: "supported",
    UNSUPPORTED: "unsupported",
};
export const NitroTpmSupport = {
    SUPPORTED: "supported",
    UNSUPPORTED: "unsupported",
};
export const PlacementGroupStrategy = {
    cluster: "cluster",
    partition: "partition",
    spread: "spread",
};
export const ArchitectureType = {
    arm64: "arm64",
    arm64_mac: "arm64_mac",
    i386: "i386",
    x86_64: "x86_64",
    x86_64_mac: "x86_64_mac",
};
export const SupportedAdditionalProcessorFeature = {
    AMD_SEV_SNP: "amd-sev-snp",
};
export const BootModeType = {
    legacy_bios: "legacy-bios",
    uefi: "uefi",
};
export const RootDeviceType = {
    ebs: "ebs",
    instance_store: "instance-store",
};
export const UsageClassType = {
    capacity_block: "capacity-block",
    on_demand: "on-demand",
    spot: "spot",
};
export const LockState = {
    compliance: "compliance",
    compliance_cooloff: "compliance-cooloff",
    expired: "expired",
    governance: "governance",
};
export const MoveStatus = {
    movingToVpc: "movingToVpc",
    restoringToClassic: "restoringToClassic",
};
export const FindingsFound = {
    false: "false",
    true: "true",
    unknown: "unknown",
};
export const AnalysisStatus = {
    failed: "failed",
    running: "running",
    succeeded: "succeeded",
};
export const NetworkInterfaceAttribute = {
    attachment: "attachment",
    description: "description",
    groupSet: "groupSet",
    sourceDestCheck: "sourceDestCheck",
};
export const OfferingClassType = {
    CONVERTIBLE: "convertible",
    STANDARD: "standard",
};
export const OfferingTypeValues = {
    All_Upfront: "All Upfront",
    Heavy_Utilization: "Heavy Utilization",
    Light_Utilization: "Light Utilization",
    Medium_Utilization: "Medium Utilization",
    No_Upfront: "No Upfront",
    Partial_Upfront: "Partial Upfront",
};
export const RIProductDescription = {
    Linux_UNIX: "Linux/UNIX",
    Linux_UNIX_Amazon_VPC_: "Linux/UNIX (Amazon VPC)",
    Windows: "Windows",
    Windows_Amazon_VPC_: "Windows (Amazon VPC)",
};
export const RecurringChargeFrequency = {
    Hourly: "Hourly",
};
export const Scope = {
    AVAILABILITY_ZONE: "Availability Zone",
    REGIONAL: "Region",
};
export const ReservedInstanceState = {
    active: "active",
    payment_failed: "payment-failed",
    payment_pending: "payment-pending",
    queued: "queued",
    queued_deleted: "queued-deleted",
    retired: "retired",
};
export const SnapshotAttributeName = {
    createVolumePermission: "createVolumePermission",
    productCodes: "productCodes",
};
export const TieringOperationStatus = {
    archival_completed: "archival-completed",
    archival_failed: "archival-failed",
    archival_in_progress: "archival-in-progress",
    permanent_restore_completed: "permanent-restore-completed",
    permanent_restore_failed: "permanent-restore-failed",
    permanent_restore_in_progress: "permanent-restore-in-progress",
    temporary_restore_completed: "temporary-restore-completed",
    temporary_restore_failed: "temporary-restore-failed",
    temporary_restore_in_progress: "temporary-restore-in-progress",
};
export const EventType = {
    BATCH_CHANGE: "fleetRequestChange",
    ERROR: "error",
    INFORMATION: "information",
    INSTANCE_CHANGE: "instanceChange",
};
export const ExcessCapacityTerminationPolicy = {
    DEFAULT: "default",
    NO_TERMINATION: "noTermination",
};
export const OnDemandAllocationStrategy = {
    LOWEST_PRICE: "lowestPrice",
    PRIORITIZED: "prioritized",
};
export const ReplacementStrategy = {
    LAUNCH: "launch",
    LAUNCH_BEFORE_TERMINATE: "launch-before-terminate",
};
export const SpotInstanceState = {
    active: "active",
    cancelled: "cancelled",
    closed: "closed",
    disabled: "disabled",
    failed: "failed",
    open: "open",
};
export const SnapshotTaskDetailFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Url && { Url: SENSITIVE_STRING }),
});
export const ImportSnapshotTaskFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SnapshotTaskDetail && { SnapshotTaskDetail: SnapshotTaskDetailFilterSensitiveLog(obj.SnapshotTaskDetail) }),
});
export const DescribeImportSnapshotTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ImportSnapshotTasks && {
        ImportSnapshotTasks: obj.ImportSnapshotTasks.map((item) => ImportSnapshotTaskFilterSensitiveLog(item)),
    }),
});
export const DescribeLaunchTemplateVersionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchTemplateVersions && {
        LaunchTemplateVersions: obj.LaunchTemplateVersions.map((item) => LaunchTemplateVersionFilterSensitiveLog(item)),
    }),
});
export const SpotFleetLaunchSpecificationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserData && { UserData: SENSITIVE_STRING }),
});
export const SpotFleetRequestConfigDataFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchSpecifications && {
        LaunchSpecifications: obj.LaunchSpecifications.map((item) => SpotFleetLaunchSpecificationFilterSensitiveLog(item)),
    }),
});
export const SpotFleetRequestConfigFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SpotFleetRequestConfig && {
        SpotFleetRequestConfig: SpotFleetRequestConfigDataFilterSensitiveLog(obj.SpotFleetRequestConfig),
    }),
});
export const DescribeSpotFleetRequestsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const LaunchSpecificationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserData && { UserData: SENSITIVE_STRING }),
});
export const SpotInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchSpecification && {
        LaunchSpecification: LaunchSpecificationFilterSensitiveLog(obj.LaunchSpecification),
    }),
});
export const DescribeSpotInstanceRequestsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SpotInstanceRequests && {
        SpotInstanceRequests: obj.SpotInstanceRequests.map((item) => SpotInstanceRequestFilterSensitiveLog(item)),
    }),
});
