import { VerifiedAccessTrustProviderFilterSensitiveLog, } from "./models_0";
import { VpnConnectionFilterSensitiveLog, } from "./models_2";
export const VerifiedAccessLogDeliveryStatusCode = {
    FAILED: "failed",
    SUCCESS: "success",
};
export const VolumeAttributeName = {
    autoEnableIO: "autoEnableIO",
    productCodes: "productCodes",
};
export const VolumeModificationState = {
    completed: "completed",
    failed: "failed",
    modifying: "modifying",
    optimizing: "optimizing",
};
export const VolumeStatusName = {
    io_enabled: "io-enabled",
    io_performance: "io-performance",
};
export const VolumeStatusInfoStatus = {
    impaired: "impaired",
    insufficient_data: "insufficient-data",
    ok: "ok",
};
export const VpcAttributeName = {
    enableDnsHostnames: "enableDnsHostnames",
    enableDnsSupport: "enableDnsSupport",
    enableNetworkAddressUsageMetrics: "enableNetworkAddressUsageMetrics",
};
export const ImageBlockPublicAccessDisabledState = {
    unblocked: "unblocked",
};
export const SnapshotBlockPublicAccessState = {
    block_all_sharing: "block-all-sharing",
    block_new_sharing: "block-new-sharing",
    unblocked: "unblocked",
};
export const TransitGatewayPropagationState = {
    disabled: "disabled",
    disabling: "disabling",
    enabled: "enabled",
    enabling: "enabling",
};
export const ImageBlockPublicAccessEnabledState = {
    block_new_sharing: "block-new-sharing",
};
export const ClientCertificateRevocationListStatusCode = {
    active: "active",
    pending: "pending",
};
export const UnlimitedSupportedInstanceFamily = {
    t2: "t2",
    t3: "t3",
    t3a: "t3a",
    t4g: "t4g",
};
export const PartitionLoadFrequency = {
    DAILY: "daily",
    MONTHLY: "monthly",
    NONE: "none",
    WEEKLY: "weekly",
};
export const IpamComplianceStatus = {
    compliant: "compliant",
    ignored: "ignored",
    noncompliant: "noncompliant",
    unmanaged: "unmanaged",
};
export const IpamOverlapStatus = {
    ignored: "ignored",
    nonoverlapping: "nonoverlapping",
    overlapping: "overlapping",
};
export const IpamAddressHistoryResourceType = {
    eip: "eip",
    instance: "instance",
    network_interface: "network-interface",
    subnet: "subnet",
    vpc: "vpc",
};
export const IpamDiscoveryFailureCode = {
    assume_role_failure: "assume-role-failure",
    throttling_failure: "throttling-failure",
    unauthorized_failure: "unauthorized-failure",
};
export const IpamPublicAddressType = {
    AMAZON_OWNED_EIP: "amazon-owned-eip",
    BYOIP: "byoip",
    EC2_PUBLIC_IP: "ec2-public-ip",
    SERVICE_MANAGED_BYOIP: "service-managed-byoip",
    SERVICE_MANAGED_IP: "service-managed-ip",
};
export const IpamPublicAddressAssociationStatus = {
    ASSOCIATED: "associated",
    DISASSOCIATED: "disassociated",
};
export const IpamPublicAddressAwsService = {
    AGA: "global-accelerator",
    DMS: "database-migration-service",
    EC2_LB: "load-balancer",
    ECS: "elastic-container-service",
    NAT_GATEWAY: "nat-gateway",
    OTHER: "other",
    RDS: "relational-database-service",
    REDSHIFT: "redshift",
    S2S_VPN: "site-to-site-vpn",
};
export const DescribeVerifiedAccessTrustProvidersResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VerifiedAccessTrustProviders && {
        VerifiedAccessTrustProviders: obj.VerifiedAccessTrustProviders.map((item) => VerifiedAccessTrustProviderFilterSensitiveLog(item)),
    }),
});
export const DescribeVpnConnectionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VpnConnections && {
        VpnConnections: obj.VpnConnections.map((item) => VpnConnectionFilterSensitiveLog(item)),
    }),
});
export const DetachVerifiedAccessTrustProviderResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VerifiedAccessTrustProvider && {
        VerifiedAccessTrustProvider: VerifiedAccessTrustProviderFilterSensitiveLog(obj.VerifiedAccessTrustProvider),
    }),
});
