import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { VerifiedAccessTrustProviderFilterSensitiveLog, } from "./models_0";
import { ResponseLaunchTemplateDataFilterSensitiveLog, } from "./models_1";
import { VpnConnectionFilterSensitiveLog, } from "./models_2";
import { ConversionTaskFilterSensitiveLog, SnapshotDetailFilterSensitiveLog, } from "./models_3";
import { SnapshotTaskDetailFilterSensitiveLog, } from "./models_4";
export const IpamResourceType = {
    eip: "eip",
    eni: "eni",
    ipv6_pool: "ipv6-pool",
    public_ipv4_pool: "public-ipv4-pool",
    subnet: "subnet",
    vpc: "vpc",
};
export const IpamManagementState = {
    ignored: "ignored",
    managed: "managed",
    unmanaged: "unmanaged",
};
export const LockMode = {
    compliance: "compliance",
    governance: "governance",
};
export const ModifyAvailabilityZoneOptInStatus = {
    not_opted_in: "not-opted-in",
    opted_in: "opted-in",
};
export const OperationType = {
    add: "add",
    remove: "remove",
};
export const UnsuccessfulInstanceCreditSpecificationErrorCode = {
    INCORRECT_INSTANCE_STATE: "IncorrectInstanceState",
    INSTANCE_CREDIT_SPECIFICATION_NOT_SUPPORTED: "InstanceCreditSpecification.NotSupported",
    INSTANCE_NOT_FOUND: "InvalidInstanceID.NotFound",
    INVALID_INSTANCE_ID: "InvalidInstanceID.Malformed",
};
export const HostTenancy = {
    dedicated: "dedicated",
    host: "host",
};
export const TargetStorageTier = {
    archive: "archive",
};
export const TrafficMirrorFilterRuleField = {
    description: "description",
    destination_port_range: "destination-port-range",
    protocol: "protocol",
    source_port_range: "source-port-range",
};
export const TrafficMirrorSessionField = {
    description: "description",
    packet_length: "packet-length",
    virtual_network_id: "virtual-network-id",
};
export const VpcTenancy = {
    default: "default",
};
export const Status = {
    inClassic: "InClassic",
    inVpc: "InVpc",
    moveInProgress: "MoveInProgress",
};
export const GetLaunchTemplateDataResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LaunchTemplateData && {
        LaunchTemplateData: ResponseLaunchTemplateDataFilterSensitiveLog(obj.LaunchTemplateData),
    }),
});
export const GetPasswordDataResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PasswordData && { PasswordData: SENSITIVE_STRING }),
});
export const GetVpnConnectionDeviceSampleConfigurationResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VpnConnectionDeviceSampleConfiguration && { VpnConnectionDeviceSampleConfiguration: SENSITIVE_STRING }),
});
export const ImageDiskContainerFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Url && { Url: SENSITIVE_STRING }),
});
export const ImportImageRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DiskContainers && {
        DiskContainers: obj.DiskContainers.map((item) => ImageDiskContainerFilterSensitiveLog(item)),
    }),
});
export const ImportImageResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SnapshotDetails && {
        SnapshotDetails: obj.SnapshotDetails.map((item) => SnapshotDetailFilterSensitiveLog(item)),
    }),
});
export const DiskImageDetailFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ImportManifestUrl && { ImportManifestUrl: SENSITIVE_STRING }),
});
export const DiskImageFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Image && { Image: DiskImageDetailFilterSensitiveLog(obj.Image) }),
});
export const UserDataFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ImportInstanceLaunchSpecificationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserData && { UserData: SENSITIVE_STRING }),
});
export const ImportInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DiskImages && { DiskImages: obj.DiskImages.map((item) => DiskImageFilterSensitiveLog(item)) }),
    ...(obj.LaunchSpecification && {
        LaunchSpecification: ImportInstanceLaunchSpecificationFilterSensitiveLog(obj.LaunchSpecification),
    }),
});
export const ImportInstanceResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ConversionTask && { ConversionTask: ConversionTaskFilterSensitiveLog(obj.ConversionTask) }),
});
export const SnapshotDiskContainerFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Url && { Url: SENSITIVE_STRING }),
});
export const ImportSnapshotRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DiskContainer && { DiskContainer: SnapshotDiskContainerFilterSensitiveLog(obj.DiskContainer) }),
});
export const ImportSnapshotResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SnapshotTaskDetail && { SnapshotTaskDetail: SnapshotTaskDetailFilterSensitiveLog(obj.SnapshotTaskDetail) }),
});
export const ImportVolumeRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Image && { Image: DiskImageDetailFilterSensitiveLog(obj.Image) }),
});
export const ImportVolumeResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ConversionTask && { ConversionTask: ConversionTaskFilterSensitiveLog(obj.ConversionTask) }),
});
export const ModifyVerifiedAccessTrustProviderOidcOptionsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ClientSecret && { ClientSecret: SENSITIVE_STRING }),
});
export const ModifyVerifiedAccessTrustProviderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OidcOptions && {
        OidcOptions: ModifyVerifiedAccessTrustProviderOidcOptionsFilterSensitiveLog(obj.OidcOptions),
    }),
});
export const ModifyVerifiedAccessTrustProviderResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VerifiedAccessTrustProvider && {
        VerifiedAccessTrustProvider: VerifiedAccessTrustProviderFilterSensitiveLog(obj.VerifiedAccessTrustProvider),
    }),
});
export const ModifyVpnConnectionResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VpnConnection && { VpnConnection: VpnConnectionFilterSensitiveLog(obj.VpnConnection) }),
});
export const ModifyVpnConnectionOptionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VpnConnection && { VpnConnection: VpnConnectionFilterSensitiveLog(obj.VpnConnection) }),
});
export const ModifyVpnTunnelCertificateResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VpnConnection && { VpnConnection: VpnConnectionFilterSensitiveLog(obj.VpnConnection) }),
});
export const ModifyVpnTunnelOptionsSpecificationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PreSharedKey && { PreSharedKey: SENSITIVE_STRING }),
});
export const ModifyVpnTunnelOptionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TunnelOptions && { TunnelOptions: SENSITIVE_STRING }),
});
export const ModifyVpnTunnelOptionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.VpnConnection && { VpnConnection: VpnConnectionFilterSensitiveLog(obj.VpnConnection) }),
});
