import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ApplySecurityGroupsToClientVpnTargetNetworkRequest, ApplySecurityGroupsToClientVpnTargetNetworkResult } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ApplySecurityGroupsToClientVpnTargetNetworkCommand}.
 */
export interface ApplySecurityGroupsToClientVpnTargetNetworkCommandInput extends ApplySecurityGroupsToClientVpnTargetNetworkRequest {
}
/**
 * @public
 *
 * The output of {@link ApplySecurityGroupsToClientVpnTargetNetworkCommand}.
 */
export interface ApplySecurityGroupsToClientVpnTargetNetworkCommandOutput extends ApplySecurityGroupsToClientVpnTargetNetworkResult, __MetadataBearer {
}
declare const ApplySecurityGroupsToClientVpnTargetNetworkCommand_base: {
    new (input: ApplySecurityGroupsToClientVpnTargetNetworkCommandInput): import("@smithy/smithy-client").CommandImpl<ApplySecurityGroupsToClientVpnTargetNetworkCommandInput, ApplySecurityGroupsToClientVpnTargetNetworkCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: ApplySecurityGroupsToClientVpnTargetNetworkCommandInput): import("@smithy/smithy-client").CommandImpl<ApplySecurityGroupsToClientVpnTargetNetworkCommandInput, ApplySecurityGroupsToClientVpnTargetNetworkCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Applies a security group to the association between the target network and the Client VPN endpoint. This action replaces the existing
 * 			security groups with the specified security groups.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ApplySecurityGroupsToClientVpnTargetNetworkCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ApplySecurityGroupsToClientVpnTargetNetworkCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // ApplySecurityGroupsToClientVpnTargetNetworkRequest
 *   ClientVpnEndpointId: "STRING_VALUE", // required
 *   VpcId: "STRING_VALUE", // required
 *   SecurityGroupIds: [ // ClientVpnSecurityGroupIdSet // required
 *     "STRING_VALUE",
 *   ],
 *   DryRun: true || false,
 * };
 * const command = new ApplySecurityGroupsToClientVpnTargetNetworkCommand(input);
 * const response = await client.send(command);
 * // { // ApplySecurityGroupsToClientVpnTargetNetworkResult
 * //   SecurityGroupIds: [ // ClientVpnSecurityGroupIdSet
 * //     "STRING_VALUE",
 * //   ],
 * // };
 *
 * ```
 *
 * @param ApplySecurityGroupsToClientVpnTargetNetworkCommandInput - {@link ApplySecurityGroupsToClientVpnTargetNetworkCommandInput}
 * @returns {@link ApplySecurityGroupsToClientVpnTargetNetworkCommandOutput}
 * @see {@link ApplySecurityGroupsToClientVpnTargetNetworkCommandInput} for command's `input` shape.
 * @see {@link ApplySecurityGroupsToClientVpnTargetNetworkCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class ApplySecurityGroupsToClientVpnTargetNetworkCommand extends ApplySecurityGroupsToClientVpnTargetNetworkCommand_base {
}
