import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { AssociateEnclaveCertificateIamRoleRequest, AssociateEnclaveCertificateIamRoleResult } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link AssociateEnclaveCertificateIamRoleCommand}.
 */
export interface AssociateEnclaveCertificateIamRoleCommandInput extends AssociateEnclaveCertificateIamRoleRequest {
}
/**
 * @public
 *
 * The output of {@link AssociateEnclaveCertificateIamRoleCommand}.
 */
export interface AssociateEnclaveCertificateIamRoleCommandOutput extends AssociateEnclaveCertificateIamRoleResult, __MetadataBearer {
}
declare const AssociateEnclaveCertificateIamRoleCommand_base: {
    new (input: AssociateEnclaveCertificateIamRoleCommandInput): import("@smithy/smithy-client").CommandImpl<AssociateEnclaveCertificateIamRoleCommandInput, AssociateEnclaveCertificateIamRoleCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (__0_0: AssociateEnclaveCertificateIamRoleCommandInput): import("@smithy/smithy-client").CommandImpl<AssociateEnclaveCertificateIamRoleCommandInput, AssociateEnclaveCertificateIamRoleCommandOutput, EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM) certificate.
 * 			This enables the certificate to be used by the ACM for Nitro Enclaves application inside an enclave. For more
 * 			information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html">Certificate Manager for Nitro Enclaves</a> in the <i>Amazon Web Services Nitro Enclaves
 * 					User Guide</i>.</p>
 *          <p>When the IAM role is associated with the ACM certificate, the certificate, certificate chain, and encrypted
 * 			private key are placed in an Amazon S3 location that only the associated IAM role can access. The private key of the certificate
 * 			is encrypted with an Amazon Web Services managed key that has an attached attestation-based key policy.</p>
 *          <p>To enable the IAM role to access the Amazon S3 object, you must grant it permission to call <code>s3:GetObject</code>
 * 			on the Amazon S3 bucket returned by the command. To enable the IAM role to access the KMS key,
 * 			you must grant it permission to call <code>kms:Decrypt</code> on the KMS key returned by the command.
 * 			For more information, see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy">
 * 				Grant the role permission to access the certificate and encryption key</a> in the
 * 			<i>Amazon Web Services Nitro Enclaves User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, AssociateEnclaveCertificateIamRoleCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, AssociateEnclaveCertificateIamRoleCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const input = { // AssociateEnclaveCertificateIamRoleRequest
 *   CertificateArn: "STRING_VALUE", // required
 *   RoleArn: "STRING_VALUE", // required
 *   DryRun: true || false,
 * };
 * const command = new AssociateEnclaveCertificateIamRoleCommand(input);
 * const response = await client.send(command);
 * // { // AssociateEnclaveCertificateIamRoleResult
 * //   CertificateS3BucketName: "STRING_VALUE",
 * //   CertificateS3ObjectKey: "STRING_VALUE",
 * //   EncryptionKmsKeyId: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param AssociateEnclaveCertificateIamRoleCommandInput - {@link AssociateEnclaveCertificateIamRoleCommandInput}
 * @returns {@link AssociateEnclaveCertificateIamRoleCommandOutput}
 * @see {@link AssociateEnclaveCertificateIamRoleCommandInput} for command's `input` shape.
 * @see {@link AssociateEnclaveCertificateIamRoleCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 * @throws {@link EC2ServiceException}
 * <p>Base exception class for all service exceptions from EC2 service.</p>
 *
 * @public
 */
export declare class AssociateEnclaveCertificateIamRoleCommand extends AssociateEnclaveCertificateIamRoleCommand_base {
}
